/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.gametest;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4516;
import net.minecraft.class_5321;
import net.minecraft.class_6302;
import net.minecraft.class_6880;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.helper.IAbilityHelpers;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "cyclopscore:empty";
    public static final class_2338 POS = class_2338.field_10980;

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerAbilityNotEnoughXp(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 0;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 3);
            helper.method_46226(GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, false, true).isEmpty(), "Expected not to be addable in simulate-mode");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)0, "Expect ability store of size 1");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerAbilityValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 300;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 3);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, false, true).isEmpty(), "Expected to be addable in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, true, true).isEmpty(), "Expected to be addable");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.method_46226(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.method_56606(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.method_56606((Object)store.get().getAbility((class_6880<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
            helper.method_56606((Object)player.field_7495, (Object)0, "Expect XP to have been lowered");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerAbilityInvalidLevelTooHigh(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 600;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 6);
            helper.method_56606((Object)GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, false, true).getLevel(), (Object)5, "Expected added ability to be of level 5 in simulate-mode");
            helper.method_56606((Object)GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, true, true).getLevel(), (Object)5, "Expected added ability to be of level 5");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.method_46226(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.method_56606(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.method_56606((Object)store.get().getAbility((class_6880<IAbilityType>)abilityType).getLevel(), (Object)5, "Expect ability level to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerAbilityMultipleSameValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 300;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability1 = new Ability((class_6880<IAbilityType>)abilityType, 1);
            Ability ability2 = new Ability((class_6880<IAbilityType>)abilityType, 1);
            Ability ability3 = new Ability((class_6880<IAbilityType>)abilityType, 1);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, false, true).isEmpty(), "Expected to be addable (1) in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, true, true).isEmpty(), "Expected to be addable (1)");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be addable (2) in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be addable (2)");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, false, true).isEmpty(), "Expected to be addable (3) in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, true, true).isEmpty(), "Expected to be addable (3)");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.method_46226(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.method_56606(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.method_56606((Object)store.get().getAbility((class_6880<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerAbilityMultipleDifferentValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 1000;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType1 = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            class_6880.class_6883 abilityType2 = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/darkness")));
            Ability ability1 = new Ability((class_6880<IAbilityType>)abilityType1, 1);
            Ability ability2 = new Ability((class_6880<IAbilityType>)abilityType2, 1);
            Ability ability3 = new Ability((class_6880<IAbilityType>)abilityType1, 1);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, false, true).isEmpty(), "Expected to be addable (1) in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, true, true).isEmpty(), "Expected to be addable (1)");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be addable (2) in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be addable (2)");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, false, true).isEmpty(), "Expected to be addable (3) in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, true, true).isEmpty(), "Expected to be addable (3)");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)2, "Expect ability store of size 2");
            helper.method_46226(store.get().getAbility((class_6880<IAbilityType>)abilityType1).getAbilityType() != null, "Expect ability type 1 to be contained");
            helper.method_56606(store.get().getAbility((class_6880<IAbilityType>)abilityType1).getAbilityTypeHolder(), (Object)abilityType1, "Expect ability type 1 to be correct");
            helper.method_56606((Object)store.get().getAbility((class_6880<IAbilityType>)abilityType1).getLevel(), (Object)2, "Expect ability level 1 to be correct");
            helper.method_46226(store.get().getAbility((class_6880<IAbilityType>)abilityType2).getAbilityType() != null, "Expect ability type 2 to be contained");
            helper.method_56606(store.get().getAbility((class_6880<IAbilityType>)abilityType2).getAbilityTypeHolder(), (Object)abilityType2, "Expect ability type 2 to be correct");
            helper.method_56606((Object)store.get().getAbility((class_6880<IAbilityType>)abilityType2).getLevel(), (Object)1, "Expect ability level 2 to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerRemoveAbilityValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 300;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 3);
            GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, true, true);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability, true, true).isEmpty(), "Expected to be removable");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)0, "Expect ability store of size 0");
            helper.method_56606((Object)player.field_7495, (Object)300, "Expect XP to have been lowered again");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerRemoveAbilityMultipleSameValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player = helper.method_36021(class_1934.field_9215);
            player.field_7495 = 300;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability1 = new Ability((class_6880<IAbilityType>)abilityType, 3);
            Ability ability2 = new Ability((class_6880<IAbilityType>)abilityType, 1);
            GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, true, true);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be removable");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be removable");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be removable");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)0, "Expect ability store of size 0");
            helper.method_56606((Object)player.field_7495, (Object)300, "Expect XP to have been lowered again");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testPlayerClone(class_4516 helper) {
        helper.method_35993(() -> {
            class_1657 player1 = helper.method_36021(class_1934.field_9215);
            class_1657 player2 = helper.method_36021(class_1934.field_9215);
            player1.field_7495 = 300;
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 3);
            GameTestsCommon.getAbilityHelpers().addPlayerAbility(player1, ability, true, true);
            GameTestsCommon.getAbilityHelpers().onPlayerClone(player1, player2);
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((class_1297)player2);
            helper.method_46226(store.isPresent(), "Player has no ability store");
            helper.method_56606((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.method_46226(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.method_56606(store.get().getAbility((class_6880<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.method_56606((Object)store.get().getAbility((class_6880<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testItemAbilityValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 3);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.method_56606((Object)store.getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.method_46226(store.getAbility((class_6880<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.method_56606(store.getAbility((class_6880<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.method_56606((Object)store.getAbility((class_6880<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testItemAbilityMultipleSameValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 1);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.method_56606((Object)store.getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.method_46226(store.getAbility((class_6880<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.method_56606(store.getAbility((class_6880<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.method_56606((Object)store.getAbility((class_6880<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testItemAbilityMultipleDifferentValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType1 = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            class_6880.class_6883 abilityType2 = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/darkness")));
            Ability ability1 = new Ability((class_6880<IAbilityType>)abilityType1, 1);
            Ability ability2 = new Ability((class_6880<IAbilityType>)abilityType2, 1);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability1, store).isEmpty(), "Expected to be addable");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability2, store).isEmpty(), "Expected to be addable");
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().insert(ability1, store).isEmpty(), "Expected to be addable");
            helper.method_56606((Object)store.getAbilities().size(), (Object)2, "Expect ability store of size 2");
            helper.method_46226(store.getAbility((class_6880<IAbilityType>)abilityType1).getAbilityType() != null, "Expect ability type 1 to be contained");
            helper.method_56606(store.getAbility((class_6880<IAbilityType>)abilityType1).getAbilityTypeHolder(), (Object)abilityType1, "Expect ability type 1 to be correct");
            helper.method_56606((Object)store.getAbility((class_6880<IAbilityType>)abilityType1).getLevel(), (Object)2, "Expect ability level 1 to be correct");
            helper.method_46226(store.getAbility((class_6880<IAbilityType>)abilityType2).getAbilityType() != null, "Expect ability type 2 to be contained");
            helper.method_56606(store.getAbility((class_6880<IAbilityType>)abilityType2).getAbilityTypeHolder(), (Object)abilityType2, "Expect ability type 2 to be correct");
            helper.method_56606((Object)store.getAbility((class_6880<IAbilityType>)abilityType2).getLevel(), (Object)1, "Expect ability level 2 to be correct");
        });
    }

    @class_6302(method_35936="cyclopscore:empty")
    public void testItemAbilityRemoveValid(class_4516 helper) {
        helper.method_35993(() -> {
            class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            class_2378<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.method_35943().method_30349());
            class_6880.class_6883 abilityType = registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)class_2960.method_60655((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((class_6880<IAbilityType>)abilityType, 3);
            GameTestsCommon.getAbilityHelpers().insert(ability, store);
            helper.method_46226(!GameTestsCommon.getAbilityHelpers().extract(ability, store).isEmpty(), "Expected to be removable");
            helper.method_56606((Object)store.getAbilities().size(), (Object)0, "Expect ability store of size 0");
        });
    }

    public static IAbilityHelpers getAbilityHelpers() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers();
    }
}

