/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IInitializableMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.helper.IAbilityHelpers;

public abstract class AbilityHelpersCommon
implements IAbilityHelpers {
    protected static Predicate<class_6880<IAbilityType>> PREDICATE_ABILITY_NOT_DISABLED = ability -> !GeneralConfig.disabledAbilities.contains(ability.method_55840());
    private final IModHelpers modHelpers;
    private int maxPlayerAbilitiesClient = -1;

    public AbilityHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public int getMaxPlayerAbilitiesClient() {
        return this.maxPlayerAbilitiesClient;
    }

    @Override
    public void setMaxPlayerAbilitiesClient(int maxPlayerAbilitiesClient) {
        this.maxPlayerAbilitiesClient = maxPlayerAbilitiesClient;
    }

    @Override
    public int[] getRarityColors() {
        return new int[]{this.modHelpers.getBaseHelpers().RGBToInt(255, 255, 255), this.modHelpers.getBaseHelpers().RGBToInt(255, 255, 0), this.modHelpers.getBaseHelpers().RGBToInt(0, 255, 255), this.modHelpers.getBaseHelpers().RGBToInt(255, 0, 255)};
    }

    @Override
    public class_2378<IAbilityType> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(AbilityTypes.REGISTRY_KEY);
    }

    @Override
    public class_7225.class_7226<IAbilityType> getRegistryLookup(class_7225.class_7874 holderLookupProvider) {
        return holderLookupProvider.method_46762(AbilityTypes.REGISTRY_KEY);
    }

    @Override
    public int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level < 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    @Override
    public int getLevelForExperience(int experience) {
        int newXp;
        int i = 0;
        int lastXp = -1;
        while ((newXp = this.getExperienceForLevel(i)) <= experience && newXp > lastXp) {
            ++i;
            lastXp = newXp;
        }
        return i - 1;
    }

    @Override
    public Predicate<class_6880<IAbilityType>> createRarityPredicate(class_1814 rarity) {
        return abilityType -> ((IAbilityType)abilityType.comp_349()).getRarity() == rarity;
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypes(class_2378<IAbilityType> registry, Predicate<class_6880<IAbilityType>> abilityFilter) {
        return registry.method_40270().filter(abilityFilter).collect(Collectors.toList());
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypes(class_7225.class_7874 holderLookupProvider, Predicate<class_6880<IAbilityType>> abilityFilter) {
        return this.getRegistryLookup(holderLookupProvider).method_42017().filter(abilityFilter).collect(Collectors.toList());
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypesPlayerSpawn(class_2378<IAbilityType> registry) {
        return this.getAbilityTypes(registry, this.getPredicateAbilityEnabled().and(holder -> ((IAbilityType)holder.comp_349()).isObtainableOnPlayerSpawn()));
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypesMobSpawn(class_2378<IAbilityType> registry) {
        return this.getAbilityTypes(registry, this.getPredicateAbilityEnabled().and(holder -> ((IAbilityType)holder.comp_349()).isObtainableOnMobSpawn()));
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypesCrafting(class_2378<IAbilityType> registry) {
        return this.getAbilityTypes(registry, this.getPredicateAbilityEnabled().and(holder -> ((IAbilityType)holder.comp_349()).isObtainableOnCraft()));
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypesCrafting(class_7225.class_7874 provider) {
        return this.getAbilityTypes(provider, this.getPredicateAbilityEnabled().and(holder -> ((IAbilityType)holder.comp_349()).isObtainableOnCraft()));
    }

    @Override
    public List<class_6880<IAbilityType>> getAbilityTypesLoot(class_2378<IAbilityType> registry) {
        return this.getAbilityTypes(registry, this.getPredicateAbilityEnabled().and(holder -> ((IAbilityType)holder.comp_349()).isObtainableOnLoot()));
    }

    @Override
    public void onPlayerAbilityChanged(class_1657 player, IAbilityType abilityType, int oldLevel, int newLevel) {
        abilityType.onChangedLevel(player, oldLevel, newLevel);
    }

    @Override
    public int getMaxPlayerAbilities(class_1937 world) {
        return world.method_8608() ? this.maxPlayerAbilitiesClient : GeneralConfig.maxPlayerAbilities;
    }

    @Override
    public Ability addPlayerAbility(class_1657 player, Ability ability, boolean doAdd, boolean modifyXp) {
        return this.getEntityAbilityStore((class_1297)player).map(abilityStore -> {
            int oldLevel;
            int n = oldLevel = abilityStore.hasAbilityType(ability.getAbilityTypeHolder()) ? abilityStore.getAbility(ability.getAbilityTypeHolder()).getLevel() : 0;
            if (this.getMaxPlayerAbilities(player.method_5770()) >= 0 && oldLevel == 0 && this.getMaxPlayerAbilities(player.method_5770()) <= abilityStore.getAbilities().size()) {
                return Ability.EMPTY;
            }
            Ability result = abilityStore.addAbility(ability, doAdd);
            int currentXp = player.field_7495;
            if (result != null && modifyXp && this.getExperience(result) > currentXp) {
                int maxLevels = player.field_7495 / result.getAbilityType().getXpPerLevelScaled();
                result = maxLevels == 0 ? Ability.EMPTY : new Ability(result.getAbilityTypeHolder(), maxLevels);
            }
            if (doAdd && !result.isEmpty()) {
                player.field_7495 -= this.getExperience(result);
                player.field_7520 = this.getLevelForExperience(player.field_7495);
                int xpForLevel = this.getExperienceForLevel(player.field_7520);
                player.field_7510 = (float)(player.field_7495 - xpForLevel) / (float)player.method_7349();
                int newLevel = abilityStore.getAbility(result.getAbilityTypeHolder()).getLevel();
                this.onPlayerAbilityChanged(player, result.getAbilityType(), oldLevel, newLevel);
            }
            return result;
        }).orElse(Ability.EMPTY);
    }

    @Override
    public Ability removePlayerAbility(class_1657 player, Ability ability, boolean doRemove, boolean modifyXp) {
        return this.getEntityAbilityStore((class_1297)player).map(abilityStore -> {
            int oldLevel = abilityStore.hasAbilityType(ability.getAbilityTypeHolder()) ? abilityStore.getAbility(ability.getAbilityTypeHolder()).getLevel() : 0;
            Ability result = abilityStore.removeAbility(ability, doRemove);
            if (modifyXp && !result.isEmpty()) {
                if (doRemove) {
                    player.method_7255(this.getExperience(result));
                }
                int newLevel = abilityStore.hasAbilityType(result.getAbilityTypeHolder()) ? abilityStore.getAbility(result.getAbilityTypeHolder()).getLevel() : 0;
                this.onPlayerAbilityChanged(player, result.getAbilityType(), oldLevel, newLevel);
            }
            return result;
        }).orElse(Ability.EMPTY);
    }

    @Override
    public void setPlayerAbilities(class_3222 player, Map<class_6880<IAbilityType>, Integer> abilityTypes) {
        this.getEntityAbilityStore((class_1297)player).ifPresent(abilityStore -> abilityStore.setAbilities(abilityTypes));
    }

    @Override
    public int getExperience(Ability ability) {
        if (ability.isEmpty()) {
            return 0;
        }
        return ability.getAbilityType().getXpPerLevelScaled() * ability.getLevel();
    }

    @Override
    public boolean canInsert(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        Ability added = mutableAbilityStore.addAbility(ability, false);
        return added.getLevel() == ability.getLevel();
    }

    @Override
    public boolean canExtract(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        Ability added = mutableAbilityStore.removeAbility(ability, false);
        return added.getLevel() == ability.getLevel();
    }

    @Override
    public boolean canInsertToPlayer(Ability ability, class_1657 player) {
        Ability added = this.addPlayerAbility(player, ability, false, true);
        return added.getLevel() == ability.getLevel();
    }

    @Override
    public Ability insert(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        return mutableAbilityStore.addAbility(ability, true);
    }

    @Override
    public Ability extract(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        return mutableAbilityStore.removeAbility(ability, true);
    }

    @Override
    public Optional<class_6880<IAbilityType>> getRandomAbility(List<class_6880<IAbilityType>> abilityTypes, class_5819 random, class_1814 rarity) {
        List<class_6880<IAbilityType>> filtered = abilityTypes.stream().filter(this.createRarityPredicate(rarity)).toList();
        if (filtered.size() > 0) {
            return Optional.of(filtered.get(random.method_43048(filtered.size())));
        }
        return Optional.empty();
    }

    @Override
    public class_1799 getTotem(Ability ability) {
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_TOTEM);
        this.getItemAbilityStore(itemStack).ifPresent(mutableAbilityStore -> mutableAbilityStore.addAbility(ability, true));
        return itemStack;
    }

    @Override
    public Optional<class_6880<IAbilityType>> getRandomAbilityUntilRarity(List<class_6880<IAbilityType>> abilityTypes, class_5819 random, class_1814 rarity, boolean inclusive) {
        NavigableSet<class_1814> validRarities = this.getValidAbilityRarities(abilityTypes).headSet(rarity, inclusive);
        Iterator<class_1814> it = validRarities.descendingIterator();
        while (it.hasNext()) {
            Optional<class_6880<IAbilityType>> optional = this.getRandomAbility(abilityTypes, random, it.next());
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public Optional<class_1799> getRandomTotem(List<class_6880<IAbilityType>> abilityTypes, class_1814 rarity, class_5819 rand) {
        return this.getRandomAbility(abilityTypes, rand, rarity).flatMap(abilityType -> Optional.of(this.getTotem(new Ability((class_6880<IAbilityType>)abilityType, 1))));
    }

    @Override
    public Optional<class_1814> getRandomRarity(List<class_6880<IAbilityType>> abilityTypes, class_5819 rand) {
        int chance = rand.method_43048(50);
        class_1814 rarity = chance >= 49 ? class_1814.field_8904 : (chance >= 40 ? class_1814.field_8903 : (chance >= 25 ? class_1814.field_8907 : class_1814.field_8906));
        if (!this.hasRarityAbilities(abilityTypes, rarity)) {
            int size = abilityTypes.size();
            if (size == 0) {
                return Optional.empty();
            }
            rarity = ((IAbilityType)((class_6880)Iterables.get(abilityTypes, (int)rand.method_43048(size))).comp_349()).getRarity();
        }
        return Optional.of(rarity);
    }

    @Override
    public boolean hasRarityAbilities(List<class_6880<IAbilityType>> abilityTypes, class_1814 rarity) {
        return abilityTypes.stream().anyMatch(this.createRarityPredicate(rarity));
    }

    @Override
    public NavigableSet<class_1814> getValidAbilityRarities(List<class_6880<IAbilityType>> abilityTypes) {
        TreeSet rarities = Sets.newTreeSet();
        for (class_1814 rarity : class_1814.values()) {
            if (!this.hasRarityAbilities(abilityTypes, rarity)) continue;
            rarities.add(rarity);
        }
        return rarities;
    }

    @Override
    public Triple<Integer, Integer, Integer> getAverageRarityColor(IAbilityStore abilityStore) {
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 1;
        int[] rarityColors = this.getRarityColors();
        for (class_6880<IAbilityType> abilityType : abilityStore.getAbilityTypes()) {
            Triple color = this.modHelpers.getBaseHelpers().intToRGB(rarityColors[Math.min(rarityColors.length - 1, ((IAbilityType)abilityType.comp_349()).getRarity().ordinal())]);
            r = (int)((float)r + ((Float)color.getLeft()).floatValue() * 255.0f);
            g = (int)((float)g + ((Float)color.getMiddle()).floatValue() * 255.0f);
            b = (int)((float)b + ((Float)color.getRight()).floatValue() * 255.0f);
            ++count;
        }
        return Triple.of((Object)(r / count), (Object)(g / count), (Object)(b / count));
    }

    @Override
    public Supplier<class_1814> getSafeRarity(Supplier<Integer> rarityGetter) {
        return () -> {
            Integer rarity = (Integer)rarityGetter.get();
            return rarity < 0 ? class_1814.field_8906 : (rarity >= class_1814.values().length ? class_1814.field_8904 : class_1814.values()[rarity]);
        };
    }

    @Override
    public class_2520 serialize(class_2378<IAbilityType> registry, IMutableAbilityStore capability) {
        class_2499 list = new class_2499();
        for (Ability ability : capability.getAbilities()) {
            class_2487 tag = new class_2487();
            tag.method_10582("name", registry.method_10221((Object)ability.getAbilityType()).toString());
            tag.method_10569("level", ability.getLevel());
            list.add((Object)tag);
        }
        return list;
    }

    @Override
    public void deserialize(class_2378<IAbilityType> registry, IMutableAbilityStore capability, class_2520 nbt) {
        HashMap abilityTypes = Maps.newHashMap();
        if (nbt instanceof class_2499) {
            if (((class_2499)nbt).method_10601() == 10) {
                class_2499 list = (class_2499)nbt;
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 tag = list.method_10602(i);
                    String name = tag.method_10558("name");
                    int level = tag.method_10550("level");
                    Optional abilityTypeOptional = registry.method_55841(class_2960.method_60654((String)name));
                    if (abilityTypeOptional.isPresent()) {
                        abilityTypes.put((class_6880)abilityTypeOptional.get(), level);
                        continue;
                    }
                    EverlastingAbilitiesInstance.MOD.log(Level.WARN, "Skipped loading unknown ability by name: " + name);
                }
            }
        } else {
            EverlastingAbilitiesInstance.MOD.log(Level.WARN, "Resetting a corrupted ability storage.");
        }
        capability.setAbilities(abilityTypes);
    }

    @Override
    public void injectLootTotem(Consumer<class_1799> callback, class_47 context) {
        try {
            List<class_6880<IAbilityType>> abilityTypes = this.getAbilityTypesLoot(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(context.method_299().method_30349()));
            this.getRandomRarity(abilityTypes, context.method_294()).ifPresent(rarity -> {
                class_6880<IAbilityType> abilityType = this.getRandomAbility(abilityTypes, context.method_294(), (class_1814)rarity).get();
                class_1799 stack = new class_1799(RegistryEntries.ITEM_ABILITY_TOTEM);
                this.getItemAbilityStore(stack).ifPresent(mutableAbilityStore -> {
                    mutableAbilityStore.addAbility(new Ability(abilityType, 1), true);
                    callback.accept(stack);
                });
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canMobHaveAbility(class_1309 mob) {
        class_2960 mobName = class_7923.field_41177.method_10221((Object)mob.method_5864());
        if (mobName == null) return false;
        if (!GeneralConfig.mobDropBlacklist.stream().noneMatch(mobName.toString()::matches)) return false;
        return true;
    }

    @Override
    public void initializeEntityAbilities(class_1309 host, IInitializableMutableAbilityStore store) {
        if (!host.method_5770().field_9236 && !store.isInitialized() && GeneralConfig.mobAbilityChance > 0 && host.method_5628() % GeneralConfig.mobAbilityChance == 0 && this.canMobHaveAbility(host)) {
            class_5819 rand = class_5819.method_43047();
            rand.method_43052((long)host.method_5628());
            class_2378<IAbilityType> registry = this.getRegistry(host.method_37908().method_30349());
            List<class_6880<IAbilityType>> abilityTypes = this.getAbilityTypesMobSpawn(registry);
            this.getRandomRarity(abilityTypes, rand).flatMap(rarity -> this.getRandomAbility(abilityTypes, rand, (class_1814)rarity)).ifPresent(abilityType -> store.addAbility(new Ability((class_6880<IAbilityType>)abilityType, 1), true));
        }
    }

    @Override
    public void initializePlayerAbilitiesOnSpawn(class_1657 player) {
        class_1937 world = player.method_37908();
        if (world.method_30349().method_33310(AbilityTypes.REGISTRY_KEY).isPresent() && GeneralConfig.totemMaximumSpawnRarity >= 0 && this.isFirstTotemSpawn(player)) {
            class_1814 rarity = class_1814.values()[GeneralConfig.totemMaximumSpawnRarity];
            this.getRandomAbilityUntilRarity(this.getAbilityTypesPlayerSpawn(this.getRegistry(world.method_30349())), world.field_9229, rarity, true).ifPresent(abilityType -> {
                class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_BOTTLE);
                this.getItemAbilityStore(itemStack).ifPresent(mutableAbilityStore -> mutableAbilityStore.addAbility(new Ability((class_6880<IAbilityType>)abilityType, 1), true));
                IModHelpers.get().getItemStackHelpers().spawnItemStackToPlayer(world, player.method_24515(), itemStack, player);
                if (world instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)world;
                    class_1303.method_31493((class_3218)serverLevel, (class_243)player.method_19538(), (int)((IAbilityType)abilityType.comp_349()).getXpPerLevelScaled());
                }
            });
        }
    }

    @Override
    public void onPlayerClone(class_1657 playerOld, class_1657 playerNew) {
        IMutableAbilityStore oldStore = this.getEntityAbilityStore((class_1297)playerOld).orElse(null);
        IMutableAbilityStore newStore = this.getEntityAbilityStore((class_1297)playerNew).orElse(null);
        if (oldStore != null && newStore != null) {
            newStore.setAbilities(Maps.newHashMap(oldStore.getAbilitiesRaw()));
        }
    }

    @Override
    public void onEntityDeath(class_1297 entity, class_1282 source) {
        boolean doMobLoot = entity.method_37908().method_8450().method_8355(class_1928.field_19391);
        if (!entity.method_37908().field_9236 && (entity instanceof class_1657 ? GeneralConfig.dropAbilitiesOnPlayerDeath > 0 && (GeneralConfig.alwaysDropAbilities || source.method_5529() instanceof class_1657) : doMobLoot && source.method_5529() instanceof class_1657)) {
            this.getEntityAbilityStore(entity).ifPresent(mutableAbilityStore -> {
                int toDrop = 1;
                if (entity instanceof class_1657 && (GeneralConfig.alwaysDropAbilities || source.method_5529() instanceof class_1657)) {
                    toDrop = GeneralConfig.dropAbilitiesOnPlayerDeath;
                }
                class_1799 itemStack = new class_1799(RegistryEntries.ITEM_ABILITY_TOTEM);
                IMutableAbilityStore itemStackStore = this.getItemAbilityStore(itemStack).get();
                ArrayList abilities = Lists.newArrayList(mutableAbilityStore.getAbilities());
                for (Ability ability : abilities) {
                    Ability toRemove;
                    Ability removed;
                    if (toDrop <= 0 || (removed = mutableAbilityStore.removeAbility(toRemove = new Ability(ability.getAbilityTypeHolder(), toDrop), true)) == null) continue;
                    toDrop -= removed.getLevel();
                    itemStackStore.addAbility(removed, true);
                    entity.method_43496((class_2561)class_2561.method_43469((String)"chat.everlastingabilities.playerLostAbility", (Object[])new Object[]{entity.method_5477(), class_2561.method_43471((String)removed.getAbilityType().getTranslationKey()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(removed.getAbilityType().getRarity().method_58413())), removed.getLevel()}));
                }
                if (!itemStackStore.getAbilities().isEmpty()) {
                    IModHelpers.get().getItemStackHelpers().spawnItemStack(entity.method_37908(), entity.method_24515(), itemStack);
                }
            });
        }
    }

    @Override
    public void onEntityTick(class_1297 entity) {
        if (GeneralConfig.tickAbilities && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.getEntityAbilityStore((class_1297)player).ifPresent(abilityStore -> {
                for (Ability ability : abilityStore.getAbilities()) {
                    if (!this.getPredicateAbilityEnabled().test(ability.getAbilityTypeHolder())) continue;
                    if (entity.method_37908().method_8510() % 20L == 0L && GeneralConfig.exhaustionPerAbilityTick > 0.0) {
                        player.method_7322((float)GeneralConfig.exhaustionPerAbilityTick);
                    }
                    ability.getAbilityType().onTick(player, ability.getLevel());
                }
            });
        }
    }
}

