/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.helper;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.resource.conditions.conditions.NotResourceCondition;
import net.fabricmc.fabric.impl.resource.conditions.conditions.TrueResourceCondition;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.ability.AbilityConditionFabric;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.ItemDataMutableAbilityStore;
import org.cyclops.everlastingabilities.attachment.AttachableMutableAbilityStore;
import org.cyclops.everlastingabilities.attachment.Attachments;
import org.cyclops.everlastingabilities.helper.AbilityHelpersCommon;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class AbilityHelpersFabric
extends AbilityHelpersCommon {
    protected static Predicate<class_6880<IAbilityType>> PREDICATE_ABILITY_ENABLED = ability -> ((AbilityConditionFabric)((IAbilityType)ability.comp_349()).getCondition()).getCondition().test(null);

    public AbilityHelpersFabric(IModHelpers modHelpers) {
        super(modHelpers);
    }

    @Override
    public Predicate<class_6880<IAbilityType>> getPredicateAbilityEnabled() {
        return PREDICATE_ABILITY_NOT_DISABLED.and(PREDICATE_ABILITY_ENABLED);
    }

    @Override
    public Optional<IMutableAbilityStore> getEntityAbilityStore(class_1297 entity) {
        AttachableMutableAbilityStore store = new AttachableMutableAbilityStore((AttachmentTarget)entity);
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            this.initializeEntityAbilities((class_1309)mob, store);
        }
        return Optional.of(store);
    }

    @Override
    public Optional<IMutableAbilityStore> getItemAbilityStore(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof ItemGuiAbilityContainer) {
            return Optional.of(new ItemDataMutableAbilityStore(itemStack));
        }
        return Optional.empty();
    }

    @Override
    public IAbilityCondition getAbilityConditionTrue() {
        return new AbilityConditionFabric((ResourceCondition)new TrueResourceCondition());
    }

    @Override
    public IAbilityCondition getAbilityConditionFalse() {
        return new AbilityConditionFabric((ResourceCondition)new NotResourceCondition((ResourceCondition)new TrueResourceCondition()));
    }

    @Override
    public Codec<IAbilityCondition> getAbilityConditionCodec() {
        return ResourceCondition.CODEC.xmap(AbilityConditionFabric::new, abilityCondition -> ((AbilityConditionFabric)abilityCondition).getCondition());
    }

    @Override
    public boolean hasPlayerStateLastFlight(class_1657 player) {
        return player.hasAttached(Attachments.LAST_FLIGHT);
    }

    @Override
    public boolean isPlayerStateLastFlight(class_1657 player) {
        return (Boolean)player.getAttachedOrSet(Attachments.LAST_FLIGHT, (Object)false);
    }

    @Override
    public void removePlayerStateLastFlight(class_1657 player) {
        player.removeAttached(Attachments.LAST_FLIGHT);
    }

    @Override
    public void setPlayerStateLastFlight(class_1657 player, boolean lastFlight) {
        player.setAttached(Attachments.LAST_FLIGHT, (Object)lastFlight);
    }

    @Override
    public boolean isFirstTotemSpawn(class_1657 player) {
        if (!player.hasAttached(Attachments.TOTEM_SPAWNED)) {
            player.setAttached(Attachments.TOTEM_SPAWNED, (Object)true);
            return true;
        }
        return false;
    }
}

