/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.inventory.container;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainerCommon;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class ContainerAbilityContainer
extends ItemInventoryContainerCommon<ItemGuiAbilityContainer> {
    public ContainerAbilityContainer(int id, class_1661 inventory, class_2540 packetBuffer) {
        this(id, inventory, ItemLocation.readFromPacketBuffer((class_2540)packetBuffer));
    }

    public ContainerAbilityContainer(int id, class_1661 inventory, ItemLocation itemLocation) {
        super((class_3917)RegistryEntries.CONTAINER_ABILITYCONTAINER.comp_349(), id, inventory, itemLocation);
        this.addInventory((class_1263)inventory, 0, 8, 195, 1, 9);
        int level = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getLevelForExperience(this.player.field_7495);
        if (this.player.field_7520 != level) {
            this.player.field_7495 = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getExperienceForLevel(this.player.field_7520);
        }
    }

    protected int getSizeInventory() {
        return 0;
    }

    public Optional<IMutableAbilityStore> getPlayerAbilityStore() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getEntityAbilityStore((class_1297)this.player);
    }

    public Optional<IMutableAbilityStore> getItemAbilityStore() {
        class_1799 itemStack = this.getItemStack(this.player);
        if (itemStack.method_7960()) {
            return Optional.empty();
        }
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getItemAbilityStore(itemStack);
    }

    public List<Ability> getPlayerAbilities() {
        return this.getPlayerAbilityStore().map(abilityStore -> Lists.newArrayList(abilityStore.getAbilities())).orElseGet(Collections::emptyList);
    }

    public List<Ability> getItemAbilities() {
        return this.getItemAbilityStore().map(abilityStore -> Lists.newArrayList(abilityStore.getAbilities())).orElseGet(Collections::emptyList);
    }

    public void moveFromPlayer(Ability playerAbility) {
        this.getItemAbilityStore().ifPresent(abilityStore -> {
            Ability insertedAbility = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().insert(playerAbility, (IMutableAbilityStore)abilityStore);
            if (!insertedAbility.isEmpty()) {
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().removePlayerAbility(this.player, insertedAbility, true, true);
            }
        });
    }

    public void moveToPlayer(Ability itemAbility) {
        this.getItemAbilityStore().ifPresent(abilityStore -> {
            Ability insertedAbility = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().addPlayerAbility(this.player, itemAbility, true, true);
            if (!insertedAbility.isEmpty()) {
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().extract(insertedAbility, (IMutableAbilityStore)abilityStore);
                if (this.getItemAbilities().isEmpty() && !((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer()) {
                    this.itemLocation.setItemStack(this.player, class_1799.field_8037);
                }
            }
        });
    }

    public boolean method_7597(class_1657 player) {
        return !this.getItemStack(player).method_7960() && (((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer() || !this.getItemAbilities().isEmpty());
    }
}

