/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.recipe;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import org.cyclops.cyclopscore.helper.IItemStackHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;

public class TotemRecycleRecipe
extends class_1852 {
    private final class_5819 rand = class_5819.method_43047();
    private long seed = this.rand.method_43055();

    public TotemRecycleRecipe(class_7710 craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(class_9694 invCrafting, class_1937 world) {
        if (ItemAbilityTotemConfig.totemCraftingCount <= 0) {
            return false;
        }
        int inputCount = 0;
        for (int i = 0; i < invCrafting.method_59983(); ++i) {
            class_1799 slot = invCrafting.method_59984(i);
            if (slot.method_7960()) continue;
            if (slot.method_7909() instanceof ItemAbilityTotem) {
                ++inputCount;
                continue;
            }
            return false;
        }
        return inputCount == ItemAbilityTotemConfig.totemCraftingCount;
    }

    public class_1799 assemble(class_9694 invCrafting, class_7225.class_7874 holderLookupProvider) {
        this.rand.method_43052(this.seed);
        int inputTargetIndex = this.rand.method_43048(ItemAbilityTotemConfig.totemCraftingCount);
        class_2371 sortedStacks = class_2371.method_10211();
        for (int i = 0; i < invCrafting.method_59983(); ++i) {
            class_1799 slot = invCrafting.method_59984(i);
            if (slot.method_7960()) continue;
            if (slot.method_7909() instanceof ItemAbilityTotem) {
                sortedStacks.add((Object)invCrafting.method_59984(i));
                continue;
            }
            return class_1799.field_8037;
        }
        Collections.sort(sortedStacks, Comparator.comparingInt(itemStack -> itemStack.method_57353().hashCode()));
        if (inputTargetIndex >= sortedStacks.size()) {
            return class_1799.field_8037;
        }
        class_1814 rarity = ((class_1799)sortedStacks.get(inputTargetIndex)).method_7932();
        List<class_6880<IAbilityType>> abilityTypes = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAbilityTypesCrafting(holderLookupProvider);
        if (this.rand.method_43048(100) < ItemAbilityTotemConfig.totemCraftingRarityIncreasePercent) {
            class_1814 newRarity = rarity;
            do {
                newRarity = newRarity.ordinal() < class_1814.field_8904.ordinal() ? class_1814.values()[newRarity.ordinal() + 1] : rarity;
            } while (!EverlastingAbilitiesInstance.MOD.getAbilityHelpers().hasRarityAbilities(abilityTypes, newRarity));
            rarity = newRarity;
        }
        this.rand.method_43052(this.seed + (long)sortedStacks.stream().mapToInt(itemStack -> itemStack.method_57353().hashCode()).sum());
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRandomTotem(abilityTypes, rarity, this.rand).get();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= ItemAbilityTotemConfig.totemCraftingCount;
    }

    public class_1799 method_8110(class_7225.class_7874 registryAccess) {
        return new class_1799(RegistryEntries.ITEM_ABILITY_TOTEM);
    }

    public class_2371<class_1799> getRemainingItems(class_9694 inv) {
        ++this.seed;
        class_2371 nonnulllist = class_2371.method_10213((int)inv.method_59983(), (Object)class_1799.field_8037);
        IItemStackHelpers itemStackHelpers = IModHelpers.get().getItemStackHelpers();
        for (int i = 0; i < nonnulllist.size(); ++i) {
            class_1799 item = inv.method_59984(i);
            if (!itemStackHelpers.hasCraftingRemainingItem(item)) continue;
            nonnulllist.set(i, (Object)itemStackHelpers.getCraftingRemainingItem(item));
        }
        return nonnulllist;
    }

    public class_1865<?> method_8119() {
        return (class_1865)RegistryEntries.RECIPESERIALIZER_TOTEM_RECYCLE.comp_349();
    }
}

