/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.everlastingabilities.Capabilities;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.IEverlastingAbilitiesModBase;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeAttributeModifierSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeEffectSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialBonemealerSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialFertilitySerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialFlightSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialMagnetizeSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialPowerStareSerializerConfig;
import org.cyclops.everlastingabilities.api.AbilityTypeSerializers;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.capability.CompoundTagMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.command.CommandModifyAbilities;
import org.cyclops.everlastingabilities.command.argument.ArgumentTypeAbilityConfig;
import org.cyclops.everlastingabilities.component.DataComponentAbilityStoreConfig;
import org.cyclops.everlastingabilities.gametest.GameTestsCommon;
import org.cyclops.everlastingabilities.helper.AbilityHelpersNeoForge;
import org.cyclops.everlastingabilities.helper.IAbilityHelpers;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainerConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleConfigNeoForge;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfigNeoForge;
import org.cyclops.everlastingabilities.loot.modifier.LootModifierInjectAbilityTotemConfig;
import org.cyclops.everlastingabilities.network.packet.RequestAbilityStorePacket;
import org.cyclops.everlastingabilities.proxy.ClientProxy;
import org.cyclops.everlastingabilities.proxy.CommonProxy;
import org.cyclops.everlastingabilities.recipe.TotemRecycleRecipeConfig;

@Mod(value="everlastingabilities")
public class EverlastingAbilitiesNeoForge
extends ModBaseNeoForge<EverlastingAbilitiesNeoForge>
implements IEverlastingAbilitiesModBase {
    public static EverlastingAbilitiesNeoForge _instance;
    private final IAbilityHelpers abilityHelpers;

    public EverlastingAbilitiesNeoForge(IEventBus modEventBus) {
        super("everlastingabilities", instance -> {
            _instance = instance;
            EverlastingAbilitiesInstance.MOD = instance;
        }, modEventBus);
        this.getCapabilityConstructorRegistry().registerEntity(() -> EntityType.PLAYER, (ICapabilityConstructor)new ICapabilityConstructor<Player, Void, IMutableAbilityStore, EntityType<Player>>(this){

            public BaseCapability<IMutableAbilityStore, Void> getCapability() {
                return Capabilities.MutableAbilityStore.ENTITY;
            }

            public ICapabilityProvider<Player, Void, IMutableAbilityStore> createProvider(EntityType<Player> host) {
                return (player, context) -> {
                    if (player.level().registryAccess().lookup(AbilityTypes.REGISTRY_KEY).isEmpty()) {
                        return null;
                    }
                    return new CompoundTagMutableAbilityStore(() -> ((Player)player).getPersistentData(), player.level().registryAccess());
                };
            }
        });
        ICapabilityConstructor capCtor = new ICapabilityConstructor<LivingEntity, Void, IMutableAbilityStore, EntityType<?>>(){

            public ICapabilityProvider<LivingEntity, Void, IMutableAbilityStore> createProvider(EntityType<?> key) {
                return (host, context) -> {
                    if (host.level().registryAccess().lookup(AbilityTypes.REGISTRY_KEY).isEmpty()) {
                        return null;
                    }
                    CompoundTagMutableAbilityStore store = new CompoundTagMutableAbilityStore(() -> ((LivingEntity)host).getPersistentData(), host.level().registryAccess());
                    EverlastingAbilitiesNeoForge.this.getAbilityHelpers().initializeEntityAbilities((LivingEntity)host, store);
                    return store;
                };
            }

            public BaseCapability<IMutableAbilityStore, Void> getCapability() {
                return Capabilities.MutableAbilityStore.ENTITY;
            }
        };
        this.getCapabilityConstructorRegistry().registerMobCategoryEntity(MobCategory.MONSTER, capCtor);
        this.getCapabilityConstructorRegistry().registerMobCategoryEntity(MobCategory.CREATURE, capCtor);
        this.getCapabilityConstructorRegistry().registerMobCategoryEntity(MobCategory.UNDERGROUND_WATER_CREATURE, capCtor);
        this.getCapabilityConstructorRegistry().registerMobCategoryEntity(MobCategory.WATER_CREATURE, capCtor);
        NeoForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        NeoForge.EVENT_BUS.addListener(this::onLivingDeath);
        NeoForge.EVENT_BUS.addListener(this::onPlayerClone);
        NeoForge.EVENT_BUS.addListener(this::onLivingUpdate);
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(this::onDatapackRegistryCreate);
        this.abilityHelpers = new AbilityHelpersNeoForge((IModHelpers)this.getModHelpers());
    }

    @Override
    public IAbilityHelpers getAbilityHelpers() {
        return this.abilityHelpers;
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand(Commands.CommandSelection selection, CommandBuildContext context) {
        LiteralArgumentBuilder root = super.constructBaseCommand(selection, context);
        root.then(CommandModifyAbilities.make(context));
        return root;
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_ABILITY_BOTTLE));
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig((ModBaseCommon<?>)this));
        configHandler.addConfigurable(new ArgumentTypeAbilityConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new ContainerAbilityContainerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new TotemRecycleRecipeConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemAbilityTotemConfigNeoForge());
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemAbilityBottleConfigNeoForge());
        configHandler.addConfigurable(new AbilityTypeEffectSerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new AbilityTypeAttributeModifierSerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialBonemealerSerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialFertilitySerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialFlightSerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialMagnetizeSerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialPowerStareSerializerConfig<EverlastingAbilitiesNeoForge>(this));
        configHandler.addConfigurable((ExtendedConfigCommon)new LootModifierInjectAbilityTotemConfig());
        configHandler.addConfigurable(new DataComponentAbilityStoreConfig<EverlastingAbilitiesNeoForge>(this));
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[]{GameTestsCommon.class};
    }

    public static void clog(String message) {
        EverlastingAbilitiesNeoForge.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }

    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide && this.getAbilityHelpers().getEntityAbilityStore(event.getEntity()).isPresent()) {
            this.getPacketHandler().sendToServer((PacketBase)new RequestAbilityStorePacket(event.getEntity().getUUID().toString()));
        }
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.getAbilityHelpers().initializePlayerAbilitiesOnSpawn(event.getEntity());
    }

    public void onLivingDeath(LivingDeathEvent event) {
        this.getAbilityHelpers().onEntityDeath((Entity)event.getEntity(), event.getSource());
    }

    public void onPlayerClone(PlayerEvent.Clone event) {
        this.getAbilityHelpers().onPlayerClone(event.getOriginal(), event.getEntity());
    }

    public void onLivingUpdate(EntityTickEvent.Post event) {
        this.getAbilityHelpers().onEntityTick(event.getEntity());
    }

    private void onDatapackRegistryCreate(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(AbilityTypes.REGISTRY_KEY, AbilityTypes.DIRECT_CODEC, AbilityTypes.DIRECT_CODEC);
    }

    private void onRegistriesCreate(NewRegistryEvent event) {
        AbilityTypeSerializers.REGISTRY = event.create(new RegistryBuilder(AbilityTypeSerializers.REGISTRY_KEY));
        AbilityTypeSerializers.NAME_CODEC = AbilityTypeSerializers.REGISTRY.byNameCodec();
    }
}

