/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.client.gui;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.client.gui.GuiItemRenderState;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;
import org.cyclops.everlastingabilities.network.packet.MoveAbilityPacket;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ContainerScreenAbilityContainer
extends ContainerScreenExtended<ContainerAbilityContainer> {
    private static final ResourceLocation RES_ITEM_GLINT = ItemRenderer.ENCHANTED_GLINT_ITEM;
    protected static final int ABILITY_LIST_SIZE = 6;
    protected static final int ABILITY_BOX_HEIGHT = 18;
    protected static final int ABILITY_BOX_WIDTH = 63;
    private final Player player;
    protected int startIndexPlayer = 0;
    protected int startIndexItem = 0;
    protected int absoluteSelectedIndexPlayer = -1;
    protected int absoluteSelectedIndexItem = -1;
    protected ButtonArrow buttonUp1;
    protected ButtonArrow buttonDown1;
    protected ButtonArrow buttonUp2;
    protected ButtonArrow buttonDown2;
    protected ButtonArrow buttonLeft;
    protected ButtonArrow buttonRight;
    private final IModHelpers modHelpers;

    public ContainerScreenAbilityContainer(ContainerAbilityContainer container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.player;
        this.modHelpers = IModHelpers.get();
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"textures/gui/ability_totem.png");
    }

    public void init() {
        super.init();
        this.buttonUp1 = new ButtonArrow(this.leftPos + 73, this.topPos + 83, (Component)Component.translatable((String)"gui.cyclopscore.up"), button -> {
            if (this.startIndexPlayer > 0) {
                --this.startIndexPlayer;
            }
        }, ButtonArrow.Direction.NORTH);
        this.addRenderableWidget((GuiEventListener)this.buttonUp1);
        this.buttonDown1 = new ButtonArrow(this.leftPos + 73, this.topPos + 174, (Component)Component.translatable((String)"gui.cyclopscore.down"), button -> {
            if (this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount())) {
                ++this.startIndexPlayer;
            }
        }, ButtonArrow.Direction.SOUTH);
        this.addRenderableWidget((GuiEventListener)this.buttonDown1);
        this.buttonUp2 = new ButtonArrow(this.leftPos + 88, this.topPos + 83, (Component)Component.translatable((String)"gui.cyclopscore.up"), button -> {
            if (this.startIndexItem > 0) {
                --this.startIndexItem;
            }
        }, ButtonArrow.Direction.NORTH);
        this.addRenderableWidget((GuiEventListener)this.buttonUp2);
        this.buttonDown2 = new ButtonArrow(this.leftPos + 88, this.topPos + 174, (Component)Component.translatable((String)"gui.cyclopscore.down"), button -> {
            if (this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount())) {
                ++this.startIndexItem;
            }
        }, ButtonArrow.Direction.SOUTH);
        this.addRenderableWidget((GuiEventListener)this.buttonDown2);
        Registry<IAbilityType> registry = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(this.player.level().registryAccess());
        this.buttonLeft = new ButtonArrow(this.leftPos + 76, this.topPos + 130, (Component)Component.translatable((String)"gui.cyclopscore.left"), button -> {
            if (this.canMoveToPlayer()) {
                EverlastingAbilitiesInstance.MOD.getPacketHandler().sendToServer((PacketBase)new MoveAbilityPacket(registry, this.getSelectedItemAbilitySingle(), MoveAbilityPacket.Movement.TO_PLAYER));
                this.moveToPlayer();
            }
        }, ButtonArrow.Direction.WEST);
        this.addRenderableWidget((GuiEventListener)this.buttonLeft);
        this.buttonRight = new ButtonArrow(this.leftPos + 90, this.topPos + 130, (Component)Component.translatable((String)"gui.cyclopscore.right"), button -> {
            if (this.canMoveFromPlayer()) {
                EverlastingAbilitiesInstance.MOD.getPacketHandler().sendToServer((PacketBase)new MoveAbilityPacket(registry, this.getSelectedPlayerAbilitySingle(), MoveAbilityPacket.Movement.FROM_PLAYER));
                this.moveFromPlayer();
            }
        }, ButtonArrow.Direction.EAST);
        this.addRenderableWidget((GuiEventListener)this.buttonRight);
    }

    protected int getBaseYSize() {
        return 219;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.getMenu()).getItemStack(this.player) == null) {
            return;
        }
        guiGraphics.drawString(this.font, this.player.getDisplayName().getString(), 8, 6, -1);
        guiGraphics.drawString(this.font, ((ContainerAbilityContainer)this.getMenu()).getItemStack(this.player).getHoverName().getVisualOrderText(), 102, 6, -1);
        this.drawAbilitiesTooltip(guiGraphics, 8, 83, this.getPlayerAbilities(), this.startIndexPlayer, mouseX, mouseY);
        this.drawAbilitiesTooltip(guiGraphics, 105, 83, this.getItemAbilities(), this.startIndexItem, mouseX, mouseY);
    }

    protected List<Ability> getPlayerAbilities() {
        List<Ability> abilities = ((ContainerAbilityContainer)this.getMenu()).getPlayerAbilities();
        Collections.sort(abilities);
        return abilities;
    }

    protected List<Ability> getItemAbilities() {
        List<Ability> abilities = ((ContainerAbilityContainer)this.getMenu()).getItemAbilities();
        Collections.sort(abilities);
        return abilities;
    }

    protected IMutableAbilityStore getPlayerAbilityStore() {
        return ((ContainerAbilityContainer)this.getMenu()).getPlayerAbilityStore().orElse(null);
    }

    protected IMutableAbilityStore getItemAbilityStore() {
        return ((ContainerAbilityContainer)this.getMenu()).getItemAbilityStore().orElse(null);
    }

    protected int getPlayerAbilitiesCount() {
        return this.getPlayerAbilities().size();
    }

    protected int getItemAbilitiesCount() {
        return this.getItemAbilities().size();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.getMenu()).getItemStack(this.player) == null) {
            return;
        }
        if (this.buttonUp1 != null) {
            this.buttonUp1.active = this.startIndexPlayer > 0;
            this.buttonDown1.active = this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount());
            this.buttonUp2.active = this.startIndexItem > 0;
            this.buttonDown2.active = this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount());
            this.buttonLeft.active = this.canMoveToPlayer();
            this.buttonRight.active = this.canMoveFromPlayer();
            this.buttonRight.active = this.canMoveFromPlayerByItem();
        }
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int i = this.leftPos;
        int j = this.topPos;
        this.drawFancyBackground(guiGraphics, i + 8, j + 17, 66, 61, this.getPlayerAbilityStore());
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(i + 26 - 8), (int)(j + 8 + 3), (int)(i + 75 - 8), (int)(j + 78 + 3), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
        this.drawXp(guiGraphics, i + 67, j + 70, false);
        IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, "" + this.player.totalExperience, i + 62, j + 73, 0, 0.5f, IModHelpers.get().getBaseHelpers().RGBAToInt(40, 215, 40, 255), false, Font.DisplayMode.NORMAL);
        this.drawFancyBackground(guiGraphics, i + 102, j + 17, 66, 61, this.getItemAbilityStore());
        ContainerScreenAbilityContainer.drawItemOnScreen(guiGraphics, i + 100, j + 17, 66, 61, 8, mouseX - 16, mouseY, ((ContainerAbilityContainer)this.getMenu()).getItemStack((Player)this.minecraft.player));
        this.drawAbilities(guiGraphics, this.leftPos + 8, this.topPos + 83, this.getPlayerAbilities(), this.startIndexPlayer, Integer.MAX_VALUE, this.absoluteSelectedIndexPlayer, mouseX, mouseY, this.canMoveFromPlayerByItem());
        this.drawAbilities(guiGraphics, this.leftPos + 105, this.topPos + 83, this.getItemAbilities(), this.startIndexItem, this.player.totalExperience, this.absoluteSelectedIndexItem, mouseX, mouseY, true);
    }

    public void drawFancyBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, IAbilityStore abilityStore) {
        int r = 140;
        int g = 140;
        int b = 140;
        if (abilityStore != null) {
            if (abilityStore.getAbilityTypes().isEmpty()) {
                return;
            }
            Triple<Integer, Integer, Integer> color = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAverageRarityColor(abilityStore);
            r = (Integer)color.getLeft();
            g = (Integer)color.getMiddle();
            b = (Integer)color.getRight();
        }
        float f = (float)(Util.getMillis() % 9000L) / 9000.0f;
        this.drawTexturedModalRectColor(guiGraphics, x, y, (int)(0.0f + f * 256.0f), 0, width, height, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        this.drawTexturedModalRectColor(guiGraphics, x, y, (int)(0.0f + f * 150.0f), (int)(0.0f + f * 256.0f), width, height, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    protected void drawXp(GuiGraphics guiGraphics, int x, int y, boolean reducedIntensity) {
        this.modHelpers.getRenderHelpers().blitColored(guiGraphics, this.texture, x, y, 0.0f, 219.0f, 5, 5, reducedIntensity ? 0.3f : 1.0f, reducedIntensity ? 0.3f : 1.0f, reducedIntensity ? 0.3f : 1.0f, 1.0f);
    }

    private void drawAbilities(GuiGraphics guiGraphics, int x, int y, List<Ability> abilities, int startIndex, int playerXp, int currentSelectedIndex, int mouseX, int mouseY, boolean canEdit) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            Ability ability = abilities.get(i + startIndex);
            if (canEdit) {
                boolean showActive;
                boolean active = currentSelectedIndex == i + startIndex;
                boolean bl = showActive = active || this.isPointInRegion(new Rectangle(x - this.leftPos, boxY - this.topPos, 63, 18), new Point(mouseX, mouseY));
                if (showActive) {
                    this.drawFancyBackground(guiGraphics, x, boxY - 1, 63, 18, null);
                }
            }
            this.modHelpers.getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, Component.translatable((String)ability.getAbilityType().getTranslationKey()).setStyle(Style.EMPTY.withColor(ability.getAbilityType().getRarity().color())).getString(), x + 27, boxY + 7, 0, 1.0f, 50, ARGB.opaque((int)ability.getAbilityType().getRarity().color().getColor()), false, Font.DisplayMode.NORMAL);
            this.modHelpers.getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, "" + ability.getLevel(), x + 58, boxY + 5, 0, 0.8f, -1, false, Font.DisplayMode.NORMAL);
            int requiredXp = ability.getAbilityType().getXpPerLevelScaled();
            this.drawXp(guiGraphics, x + 57, boxY + 10, playerXp < requiredXp);
            this.modHelpers.getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, "" + requiredXp, x + 53, boxY + 13, 0, 0.5f, this.modHelpers.getBaseHelpers().RGBAToInt(40, 215, 40, 255), false, Font.DisplayMode.NORMAL);
        }
    }

    private void drawAbilitiesTooltip(GuiGraphics guiGraphics, int x, int y, List<Ability> abilities, int startIndex, int mouseX, int mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point(mouseX, mouseY))) continue;
            Ability ability = abilities.get(i + startIndex);
            LinkedList lines = Lists.newLinkedList();
            lines.add(Component.translatable((String)ability.getAbilityType().getTranslationKey()).setStyle(Style.EMPTY.withColor(ability.getAbilityType().getRarity().color().getColor().intValue())));
            lines.add(Component.translatable((String)"general.everlastingabilities.level", (Object[])new Object[]{ability.getLevel(), ability.getAbilityType().getMaxLevel() == -1 ? "Inf" : Integer.valueOf(ability.getAbilityType().getMaxLevel())}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
            lines.add(Component.translatable((String)ability.getAbilityType().getUnlocalizedDescription()).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.RED})));
            lines.add(Component.translatable((String)"general.everlastingabilities.xp", (Object[])new Object[]{ability.getAbilityType().getXpPerLevelScaled(), EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getLevelForExperience(ability.getAbilityType().getXpPerLevelScaled())}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_GREEN))));
            if (!EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getPredicateAbilityEnabled().test(ability.getAbilityTypeHolder())) {
                lines.add(Component.translatable((String)"general.everlastingabilities.disabled").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_RED)).withBold(Boolean.valueOf(true))));
            }
            guiGraphics.setComponentTooltipForNextFrame(this.font, (List)lines, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    public void drawTexturedModalRectColor(GuiGraphics guiGraphics, int x, int y, int textureX, int textureY, int width, int height, float r, float g, float b, float a) {
        guiGraphics.blit(RenderPipelines.GUI_OPAQUE_TEXTURED_BACKGROUND, RES_ITEM_GLINT, x, y, (float)textureX, (float)textureY, width, height, 256, 256, ARGB.colorFromFloat((float)a, (float)r, (float)g, (float)b));
    }

    public static void drawItemOnScreen(GuiGraphics guiGraphics, int x1, int y1, int width, int height, int scale, float mouseX, float mouseY, ItemStack itemStack) {
        int x2 = x1 + width;
        int y2 = y1 + height;
        float averageX = (float)(x1 + x2) / 2.0f;
        float averageY = (float)(y1 + y2) / 2.0f;
        guiGraphics.enableScissor(x1, y1, x2, y2);
        float rotationY = (float)Math.atan((averageX - mouseX) / 40.0f);
        float rotationX = (float)Math.atan((averageY - mouseY) / 40.0f);
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI).rotateY(-182.0f + rotationY * -40.0f * ((float)Math.PI / 180)).rotateX(rotationX * 50.0f * ((float)Math.PI / 180));
        guiGraphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new GuiItemRenderState(itemStack, new Vector3f(0.0f, 0.0f, 0.0f), rotation, x1, y1, x2, y2, scale, guiGraphics.scissorStack.peek()));
        guiGraphics.disableScissor();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int newSelectedPlayer = this.canMoveFromPlayerByItem() ? this.clickAbilities(8, 83, this.getPlayerAbilities(), this.startIndexPlayer, this.absoluteSelectedIndexPlayer, mouseX, mouseY) : -2;
        int newSelectedItem = this.clickAbilities(105, 83, this.getItemAbilities(), this.startIndexItem, this.absoluteSelectedIndexItem, mouseX, mouseY);
        if (newSelectedPlayer >= -1) {
            this.absoluteSelectedIndexPlayer = newSelectedPlayer;
        }
        if (newSelectedItem >= -1) {
            this.absoluteSelectedIndexItem = newSelectedItem;
        }
        if (newSelectedPlayer < 0 && newSelectedItem < 0) {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double scrollAmount) {
        if (this.isHovering(8, 83, 63, 108, mouseX, mouseY)) {
            if (scrollAmount > 0.0) {
                if (this.startIndexPlayer > 0) {
                    --this.startIndexPlayer;
                }
            } else if (scrollAmount < 0.0 && this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount())) {
                ++this.startIndexPlayer;
            }
            return true;
        }
        if (this.isHovering(105, 83, 63, 108, mouseX, mouseY)) {
            if (scrollAmount > 0.0) {
                if (this.startIndexItem > 0) {
                    --this.startIndexItem;
                }
            } else if (scrollAmount < 0.0 && this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount())) {
                ++this.startIndexItem;
            }
            return true;
        }
        return false;
    }

    private int clickAbilities(int x, int y, List<Ability> abilities, int startIndex, int currentSelectedIndex, double mouseX, double mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point((int)mouseX, (int)mouseY))) continue;
            int absoluteIndex = startIndex + i;
            if (currentSelectedIndex == absoluteIndex) {
                return -1;
            }
            return absoluteIndex;
        }
        return -2;
    }

    public Ability getSelectedPlayerAbilitySingle() {
        Ability ability = this.getSelectedPlayerAbility();
        if (!ability.isEmpty()) {
            ability = new Ability(ability.getAbilityTypeHolder(), 1);
        }
        return ability;
    }

    public Ability getSelectedItemAbilitySingle() {
        Ability ability = this.getSelectedItemAbility();
        if (!ability.isEmpty()) {
            ability = new Ability(ability.getAbilityTypeHolder(), 1);
        }
        return ability;
    }

    public Ability getSelectedPlayerAbility() {
        List<Ability> abilities = this.getPlayerAbilities();
        if (this.absoluteSelectedIndexPlayer >= 0 && this.absoluteSelectedIndexPlayer < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexPlayer);
        }
        return Ability.EMPTY;
    }

    public Ability getSelectedItemAbility() {
        List<Ability> abilities = this.getItemAbilities();
        if (this.absoluteSelectedIndexItem >= 0 && this.absoluteSelectedIndexItem < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexItem);
        }
        return Ability.EMPTY;
    }

    public boolean canMoveFromPlayer(Ability ability, Player player, IMutableAbilityStore target) {
        return !ability.isEmpty() && EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canInsert(ability, target);
    }

    public boolean canMoveToPlayer(Ability ability, Player player) {
        return !ability.isEmpty() && EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canInsertToPlayer(ability, player);
    }

    public boolean canMoveFromPlayerByItem() {
        return ((ItemGuiAbilityContainer)((ContainerAbilityContainer)this.getMenu()).getItem()).canMoveFromPlayer();
    }

    public boolean canMoveFromPlayer() {
        if (!this.canMoveFromPlayerByItem()) {
            return false;
        }
        Ability playerAbility = this.getSelectedPlayerAbilitySingle();
        return this.canMoveFromPlayer(playerAbility, this.player, this.getItemAbilityStore());
    }

    public boolean canMoveToPlayer() {
        Ability itemAbility = this.getSelectedItemAbilitySingle();
        return this.canMoveToPlayer(itemAbility, this.player);
    }

    public void moveFromPlayer() {
        ((ContainerAbilityContainer)this.getMenu()).moveFromPlayer(this.getSelectedPlayerAbilitySingle());
    }

    public void moveToPlayer() {
        ((ContainerAbilityContainer)this.getMenu()).moveToPlayer(this.getSelectedItemAbilitySingle());
    }
}

