/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class ArgumentTypeAbility
implements ArgumentType<Input> {
    private final CommandBuildContext context;

    public ArgumentTypeAbility(CommandBuildContext context) {
        this.context = context;
    }

    public Input parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        Optional abilityOptional = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistryLookup((HolderLookup.Provider)this.context).get(ResourceKey.create(AbilityTypes.REGISTRY_KEY, (ResourceLocation)id));
        if (abilityOptional.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"chat.everlastingabilities.command.invalidAbility", (Object[])new Object[]{id})).create();
        }
        return new Input((Holder<IAbilityType>)((Holder)abilityOptional.get()));
    }

    public Collection<String> getExamples() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistryLookup((HolderLookup.Provider)this.context).listElementIds().map(k -> k.location().toString()).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public record Input(Holder<IAbilityType> abilityType) {
    }
}

