/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.helper;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.AlwaysCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NeverCondition;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.Capabilities;
import org.cyclops.everlastingabilities.ability.AbilityConditionNeoForge;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.helper.AbilityHelpersCommon;

public class AbilityHelpersNeoForge
extends AbilityHelpersCommon {
    protected static Predicate<Holder<IAbilityType>> PREDICATE_ABILITY_ENABLED = ability -> ((AbilityConditionNeoForge)((IAbilityType)ability.value()).getCondition()).getCondition().test(ICondition.IContext.EMPTY);
    private static final String PLAYER_NBT_KEY_LAST_FLIGHT = "everlastingabilities:lastFlight";
    private static final String NBT_TOTEM_SPAWNED = "everlastingabilities:totemSpawned";

    public AbilityHelpersNeoForge(IModHelpers modHelpers) {
        super(modHelpers);
    }

    @Override
    public Predicate<Holder<IAbilityType>> getPredicateAbilityEnabled() {
        return PREDICATE_ABILITY_NOT_DISABLED.and(PREDICATE_ABILITY_ENABLED);
    }

    @Override
    public Optional<IMutableAbilityStore> getEntityAbilityStore(Entity entity) {
        return Optional.ofNullable((IMutableAbilityStore)entity.getCapability(Capabilities.MutableAbilityStore.ENTITY));
    }

    @Override
    public Optional<IMutableAbilityStore> getItemAbilityStore(ItemStack itemStack) {
        return Optional.ofNullable((IMutableAbilityStore)itemStack.getCapability(Capabilities.MutableAbilityStore.ITEM));
    }

    @Override
    public IAbilityCondition getAbilityConditionTrue() {
        return new AbilityConditionNeoForge((ICondition)AlwaysCondition.INSTANCE);
    }

    @Override
    public IAbilityCondition getAbilityConditionFalse() {
        return new AbilityConditionNeoForge((ICondition)NeverCondition.INSTANCE);
    }

    @Override
    public Codec<IAbilityCondition> getAbilityConditionCodec() {
        return ICondition.CODEC.xmap(AbilityConditionNeoForge::new, abilityCondition -> ((AbilityConditionNeoForge)abilityCondition).getCondition());
    }

    @Override
    public boolean hasPlayerStateLastFlight(Player player) {
        return player.getPersistentData().contains(PLAYER_NBT_KEY_LAST_FLIGHT);
    }

    @Override
    public boolean isPlayerStateLastFlight(Player player) {
        return player.getPersistentData().getBoolean(PLAYER_NBT_KEY_LAST_FLIGHT).orElse(false);
    }

    @Override
    public void removePlayerStateLastFlight(Player player) {
        player.getPersistentData().remove(PLAYER_NBT_KEY_LAST_FLIGHT);
    }

    @Override
    public void setPlayerStateLastFlight(Player player, boolean lastFlight) {
        player.getPersistentData().putBoolean(PLAYER_NBT_KEY_LAST_FLIGHT, lastFlight);
    }

    @Override
    public boolean isFirstTotemSpawn(Player player) {
        CompoundTag playerTag;
        CompoundTag tag = player.getPersistentData();
        if (!tag.contains("PlayerPersisted")) {
            tag.put("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(playerTag = (CompoundTag)tag.getCompound("PlayerPersisted").get()).contains(NBT_TOTEM_SPAWNED)) {
            playerTag.putBoolean(NBT_TOTEM_SPAWNED, true);
            return true;
        }
        return false;
    }
}

