/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.jetbrains.annotations.NotNull;

public class LootModifierInjectAbilityTotem
extends LootModifier {
    public static final Supplier<MapCodec<LootModifierInjectAbilityTotem>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> LootModifierInjectAbilityTotem.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.list((Codec)Codec.STRING).fieldOf("loot_tables").forGetter(LootModifierInjectAbilityTotem::getLootTables)).apply((Applicative)inst, LootModifierInjectAbilityTotem::new)));
    private final List<String> lootTables;

    public LootModifierInjectAbilityTotem(LootItemCondition[] conditionsIn, List<String> lootTables) {
        super(conditionsIn);
        this.lootTables = lootTables;
    }

    public List<String> getLootTables() {
        return this.lootTables;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.getLootTables().contains(context.getQueriedLootTableId().toString())) {
            EverlastingAbilitiesInstance.MOD.getAbilityHelpers().injectLootTotem(arg_0 -> generatedLoot.add(arg_0), context);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

