/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.network.packet.SendAbilityStorePacket;

public class RequestAbilityStorePacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<RequestAbilityStorePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"request_ability_store"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestAbilityStorePacket> CODEC = RequestAbilityStorePacket.getCodec(RequestAbilityStorePacket::new);
    @CodecField
    private String entityUuid;

    public RequestAbilityStorePacket() {
        super(TYPE);
    }

    public RequestAbilityStorePacket(String entityUuid) {
        this();
        this.entityUuid = entityUuid;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(net.minecraft.world.level.Level world, Player player) {
    }

    public void actionServer(net.minecraft.world.level.Level world, ServerPlayer player) {
        try {
            UUID uuid = UUID.fromString(this.entityUuid);
            Entity entity = ((ServerLevel)world).getEntity(uuid);
            if (entity != null) {
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getEntityAbilityStore(entity).ifPresent(abilityStore -> {
                    Tag contents = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().serialize(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(world.registryAccess()), (IMutableAbilityStore)abilityStore);
                    CompoundTag tag = new CompoundTag();
                    tag.put("contents", contents);
                    EverlastingAbilitiesInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new SendAbilityStorePacket(entity.getId(), tag), player);
                });
            }
        }
        catch (IllegalArgumentException e) {
            EverlastingAbilitiesInstance.MOD.log(Level.ERROR, e.getMessage());
        }
    }
}

