/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.MapCodec;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.init.ModBaseForge;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.proxy.IClientProxyCommon;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;
import org.cyclops.everlastingabilities.CapabilitiesForge;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.IEverlastingAbilitiesModBase;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeAttributeModifierSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeEffectSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialBonemealerSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialFertilitySerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialFlightSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialMagnetizeSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialPowerStareSerializerConfig;
import org.cyclops.everlastingabilities.api.AbilityTypeSerializers;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.CompoundTagMutableAbilityStore;
import org.cyclops.everlastingabilities.command.CommandModifyAbilities;
import org.cyclops.everlastingabilities.command.argument.ArgumentTypeAbilityConfig;
import org.cyclops.everlastingabilities.component.DataComponentAbilityStoreConfig;
import org.cyclops.everlastingabilities.core.config.ExtendedConfigurableType;
import org.cyclops.everlastingabilities.core.config.configurabletypeaction.AbilitySerializerActionForge;
import org.cyclops.everlastingabilities.gametest.GameTestsCommon;
import org.cyclops.everlastingabilities.helper.AbilityHelpersForge;
import org.cyclops.everlastingabilities.helper.IAbilityHelpers;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainerConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleConfigForge;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfigForge;
import org.cyclops.everlastingabilities.loot.modifier.LootModifierInjectAbilityTotemConfig;
import org.cyclops.everlastingabilities.network.packet.RequestAbilityStorePacket;
import org.cyclops.everlastingabilities.proxy.ClientProxyForge;
import org.cyclops.everlastingabilities.proxy.CommonProxyForge;
import org.cyclops.everlastingabilities.recipe.TotemRecycleRecipeConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="everlastingabilities")
public class EverlastingAbilitiesForge
extends ModBaseForge<EverlastingAbilitiesForge>
implements IEverlastingAbilitiesModBase {
    public static EverlastingAbilitiesForge _instance;
    private final IAbilityHelpers abilityHelpers;
    public static IForgeRegistry<MapCodec<? extends IAbilityType>> REGISTRY_ABILITY_SERIALIZERS;

    public EverlastingAbilitiesForge(FMLJavaModLoadingContext context) {
        super("everlastingabilities", instance -> {
            _instance = instance;
            EverlastingAbilitiesInstance.MOD = instance;
        }, context);
        ExtendedConfigurableType.ABILITY_SERIALIZER.setAction(new AbilitySerializerActionForge());
        EntityJoinLevelEvent.BUS.addListener(this::onEntityJoinWorld);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(this::onPlayerLoggedIn);
        LivingDeathEvent.BUS.addListener(this::onLivingDeath);
        PlayerEvent.Clone.BUS.addListener(this::onPlayerClone);
        TickEvent.PlayerTickEvent.Post.BUS.addListener(this::onLivingUpdate);
        AttachCapabilitiesEvent.Entities.BUS.addListener(this::onAttachCapabilities);
        NewRegistryEvent.getBus((BusGroup)this.getModBusGroup()).addListener(this::onRegistriesCreate);
        DataPackRegistryEvent.NewRegistry.getBus((BusGroup)this.getModBusGroup()).addListener(this::onDatapackRegistryCreate);
        this.abilityHelpers = new AbilityHelpersForge((IModHelpers)this.getModHelpers());
    }

    @Override
    public IAbilityHelpers getAbilityHelpers() {
        return this.abilityHelpers;
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand(Commands.CommandSelection selection, CommandBuildContext context) {
        LiteralArgumentBuilder root = super.constructBaseCommand(selection, context);
        root.then(CommandModifyAbilities.make(context));
        return root;
    }

    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Mob) {
            Mob entity = (Mob)object;
            this.attachEntityCapability(event, (Entity)entity);
        } else {
            object = event.getObject();
            if (object instanceof Player) {
                Player entity = (Player)object;
                this.attachEntityCapability(event, (Entity)entity);
            }
        }
    }

    protected void attachEntityCapability(AttachCapabilitiesEvent<?> event, final Entity entity) {
        event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"ability_store"), new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
                if (!entity.level().registryAccess().lookup(AbilityTypes.REGISTRY_KEY).isEmpty() && capability == CapabilitiesForge.CAPABILITY) {
                    return LazyOptional.of(() -> {
                        CompoundTagMutableAbilityStore store = new CompoundTagMutableAbilityStore(() -> ((Entity)entity).getPersistentData(), entity.level().registryAccess());
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            EverlastingAbilitiesForge.this.getAbilityHelpers().initializeEntityAbilities((LivingEntity)mob, store);
                        }
                        return store;
                    }).cast();
                }
                return LazyOptional.empty();
            }
        });
    }

    protected IClientProxyCommon constructClientProxy() {
        return new ClientProxyForge();
    }

    protected ICommonProxyCommon constructCommonProxy() {
        return new CommonProxyForge();
    }

    protected boolean hasDefaultCreativeModeTab() {
        return true;
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_ABILITY_BOTTLE));
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig((ModBaseCommon<?>)this));
        configHandler.addConfigurable(new ArgumentTypeAbilityConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new ContainerAbilityContainerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new TotemRecycleRecipeConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemAbilityTotemConfigForge());
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemAbilityBottleConfigForge());
        configHandler.addConfigurable(new AbilityTypeEffectSerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new AbilityTypeAttributeModifierSerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialBonemealerSerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialFertilitySerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialFlightSerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialMagnetizeSerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable(new AbilityTypeSpecialPowerStareSerializerConfig<EverlastingAbilitiesForge>(this));
        configHandler.addConfigurable((ExtendedConfigCommon)new LootModifierInjectAbilityTotemConfig());
        configHandler.addConfigurable(new DataComponentAbilityStoreConfig<EverlastingAbilitiesForge>(this));
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[]{GameTestsCommon.class};
    }

    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide && this.getAbilityHelpers().getEntityAbilityStore(event.getEntity()).isPresent()) {
            this.getPacketHandler().sendToServer((PacketBase)new RequestAbilityStorePacket(event.getEntity().getUUID().toString()));
        }
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.getAbilityHelpers().initializePlayerAbilitiesOnSpawn(event.getEntity());
    }

    public void onLivingDeath(LivingDeathEvent event) {
        this.getAbilityHelpers().onEntityDeath((Entity)event.getEntity(), event.getSource());
    }

    public void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        this.getAbilityHelpers().onPlayerClone(event.getOriginal(), event.getEntity());
    }

    public void onLivingUpdate(TickEvent.PlayerTickEvent event) {
        this.getAbilityHelpers().onEntityTick((Entity)event.player);
    }

    private void onDatapackRegistryCreate(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(AbilityTypes.REGISTRY_KEY, AbilityTypes.DIRECT_CODEC, AbilityTypes.DIRECT_CODEC);
    }

    private void onRegistriesCreate(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(AbilityTypeSerializers.REGISTRY_KEY.location()).disableSaving().disableSync(), registry -> {
            REGISTRY_ABILITY_SERIALIZERS = registry;
            AbilityTypeSerializers.NAME_CODEC = registry.getCodec();
        });
    }
}

