/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.inventory.container;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class ContainerAbilityContainer
extends ItemInventoryContainer<ItemGuiAbilityContainer> {
    public ContainerAbilityContainer(int id, Inventory inventory, FriendlyByteBuf packetBuffer) {
        this(id, inventory, ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerAbilityContainer(int id, Inventory inventory, ItemLocation itemLocation) {
        super((MenuType)RegistryEntries.CONTAINER_ABILITYCONTAINER.value(), id, inventory, itemLocation);
        this.addInventory((Container)inventory, 0, 8, 195, 1, 9);
        int level = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getLevelForExperience(this.player.totalExperience);
        if (this.player.experienceLevel != level) {
            this.player.totalExperience = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getExperienceForLevel(this.player.experienceLevel);
        }
    }

    protected int getSizeInventory() {
        return 0;
    }

    public Optional<IMutableAbilityStore> getPlayerAbilityStore() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getEntityAbilityStore((Entity)this.player);
    }

    public Optional<IMutableAbilityStore> getItemAbilityStore() {
        ItemStack itemStack = this.getItemStack(this.player);
        if (itemStack.isEmpty()) {
            return Optional.empty();
        }
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getItemAbilityStore(itemStack);
    }

    public List<Ability> getPlayerAbilities() {
        return this.getPlayerAbilityStore().map(abilityStore -> Lists.newArrayList(abilityStore.getAbilities())).orElseGet(Collections::emptyList);
    }

    public List<Ability> getItemAbilities() {
        return this.getItemAbilityStore().map(abilityStore -> Lists.newArrayList(abilityStore.getAbilities())).orElseGet(Collections::emptyList);
    }

    public void moveFromPlayer(Ability playerAbility) {
        this.getItemAbilityStore().ifPresent(abilityStore -> {
            Ability insertedAbility = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().insert(playerAbility, (IMutableAbilityStore)abilityStore);
            if (!insertedAbility.isEmpty()) {
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().removePlayerAbility(this.player, insertedAbility, true, true);
            }
        });
    }

    public void moveToPlayer(Ability itemAbility) {
        this.getItemAbilityStore().ifPresent(abilityStore -> {
            Ability insertedAbility = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().addPlayerAbility(this.player, itemAbility, true, true);
            if (!insertedAbility.isEmpty()) {
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().extract(insertedAbility, (IMutableAbilityStore)abilityStore);
                if (this.getItemAbilities().isEmpty() && !((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer()) {
                    this.itemLocation.setItemStack(this.player, ItemStack.EMPTY);
                }
            }
        });
    }

    public boolean stillValid(Player player) {
        return !this.getItemStack(player).isEmpty() && (((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer() || !this.getItemAbilities().isEmpty());
    }
}

