/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.GatherComponentsEvent;
import org.cyclops.everlastingabilities.EverlastingAbilitiesForge;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.ItemDataMutableAbilityStore;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleForge;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAbilityBottleConfigForge
extends ItemAbilityBottleConfig<EverlastingAbilitiesForge> {
    public ItemAbilityBottleConfigForge() {
        super(EverlastingAbilitiesForge._instance, (eConfig, properties) -> new ItemAbilityBottleForge(properties.stacksTo(1)));
        GatherComponentsEvent.Item.BUS.addListener(this::modifyComponents);
        AttachCapabilitiesEvent.ItemStacks.BUS.addListener(this::registerCapability);
    }

    protected void modifyComponents(GatherComponentsEvent.Item event) {
        if (event.getOwner() == this.getInstance()) {
            event.register((DataComponentType)RegistryEntries.DATACOMPONENT_ABILITY_STORE.value(), (Object)new DefaultMutableAbilityStore());
        }
    }

    protected void registerCapability(AttachCapabilitiesEvent.ItemStacks event) {
        final ItemStack stack = (ItemStack)event.getObject();
        if (stack.getItem() instanceof ItemGuiAbilityContainer) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)this.getNamedId()), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return LazyOptional.of(() -> new ItemDataMutableAbilityStore(stack, () -> stack.set(DataComponents.RARITY, (Object)ItemAbilityTotem.getRarity(stack)))).cast();
                }
            });
        }
    }
}

