/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class ItemAbilityTotemConfig<M extends IModBase>
extends ItemConfigCommon<M> {
    @ConfigurablePropertyCommon(category="core", comment="This many totems combined in a crafting grid produces a new random totem (0 to disable)")
    public static int totemCraftingCount = 3;
    @ConfigurablePropertyCommon(category="core", comment="When combining totems, percentage chance of getting one higher rarity than normal.", configLocation=ModConfigLocation.SERVER)
    public static int totemCraftingRarityIncreasePercent = 15;

    public ItemAbilityTotemConfig(M mod, BiFunction<ItemConfigCommon<M>, Item.Properties, ? extends Item> elementConstructor) {
        super(mod, "ability_totem", elementConstructor);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Lists.newArrayList();
    }

    protected void onCreativeModeTabBuildContentsCommon(CreativeModeTab tab, CreativeModeTab.ItemDisplayParameters parameters, Consumer<ItemStack> register) {
        if (tab == this.getMod().getDefaultCreativeTab()) {
            EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistryLookup(parameters.holders()).listElements().forEach(abilityType -> {
                for (int level = 1; level <= ((IAbilityType)abilityType.value()).getMaxLevel(); ++level) {
                    Ability ability = new Ability((Holder<IAbilityType>)abilityType, level);
                    if (!EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getPredicateAbilityEnabled().test((Holder<IAbilityType>)abilityType)) continue;
                    register.accept(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getTotem(ability));
                }
            });
        }
    }
}

