/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;

public abstract class ItemGuiAbilityContainer
extends ItemGui {
    protected ItemGuiAbilityContainer(Item.Properties properties) {
        super(properties);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerAbilityContainer.class;
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).getHoverName(), ContainerAbilityContainer::new);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flagIn) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flagIn);
        EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getItemAbilityStore(itemStack).ifPresent(abilityStore -> {
            ArrayList<Ability> abilities = new ArrayList<Ability>(abilityStore.getAbilities());
            Collections.sort(abilities);
            boolean empty = true;
            for (Ability ability : abilities) {
                empty = false;
                tooltipAdder.accept((Component)Component.translatable((String)ability.getAbilityType().getTranslationKey()).append(" " + ability.getLevel()).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW))));
            }
            if (empty) {
                tooltipAdder.accept((Component)Component.translatable((String)"general.everlastingabilities.empty").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true))));
            }
        });
    }

    public abstract boolean canMoveFromPlayer();
}

