/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.recipe;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IItemStackHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;

public class TotemRecycleRecipe
extends CustomRecipe {
    private final RandomSource rand = RandomSource.create();
    private long seed = this.rand.nextLong();

    public TotemRecycleRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput invCrafting, Level world) {
        if (ItemAbilityTotemConfig.totemCraftingCount <= 0) {
            return false;
        }
        int inputCount = 0;
        for (int i = 0; i < invCrafting.size(); ++i) {
            ItemStack slot = invCrafting.getItem(i);
            if (slot.isEmpty()) continue;
            if (slot.getItem() instanceof ItemAbilityTotem) {
                ++inputCount;
                continue;
            }
            return false;
        }
        return inputCount == ItemAbilityTotemConfig.totemCraftingCount;
    }

    public ItemStack assemble(CraftingInput invCrafting, HolderLookup.Provider holderLookupProvider) {
        this.rand.setSeed(this.seed);
        int inputTargetIndex = this.rand.nextInt(ItemAbilityTotemConfig.totemCraftingCount);
        NonNullList sortedStacks = NonNullList.create();
        for (int i = 0; i < invCrafting.size(); ++i) {
            ItemStack slot = invCrafting.getItem(i);
            if (slot.isEmpty()) continue;
            if (slot.getItem() instanceof ItemAbilityTotem) {
                sortedStacks.add((Object)invCrafting.getItem(i));
                continue;
            }
            return ItemStack.EMPTY;
        }
        Collections.sort(sortedStacks, Comparator.comparingInt(itemStack -> itemStack.getComponents().hashCode()));
        if (inputTargetIndex >= sortedStacks.size()) {
            return ItemStack.EMPTY;
        }
        Rarity rarity = ((ItemStack)sortedStacks.get(inputTargetIndex)).getRarity();
        List<Holder<IAbilityType>> abilityTypes = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAbilityTypesCrafting(holderLookupProvider);
        if (this.rand.nextInt(100) < ItemAbilityTotemConfig.totemCraftingRarityIncreasePercent) {
            Rarity newRarity = rarity;
            do {
                newRarity = newRarity.ordinal() < Rarity.EPIC.ordinal() ? Rarity.values()[newRarity.ordinal() + 1] : rarity;
            } while (!EverlastingAbilitiesInstance.MOD.getAbilityHelpers().hasRarityAbilities(abilityTypes, newRarity));
            rarity = newRarity;
        }
        this.rand.setSeed(this.seed + (long)sortedStacks.stream().mapToInt(itemStack -> itemStack.getComponents().hashCode()).sum());
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRandomTotem(abilityTypes, rarity, this.rand).get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        ++this.seed;
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        IItemStackHelpers itemStackHelpers = IModHelpers.get().getItemStackHelpers();
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.getItem(i);
            ItemStack remaining = itemStackHelpers.getCraftingRemainingItem(item);
            if (remaining.isEmpty()) continue;
            nonnulllist.set(i, (Object)itemStackHelpers.getCraftingRemainingItem(item));
        }
        return nonnulllist;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_TOTEM_RECYCLE.value();
    }
}

