/*
 * Decompiled with CFR 0.152.
 */
package net.awt.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.LocalDate;
import java.time.Month;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8020;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_8020.class})
public class LogoDrawerMixin {
    private static final class_2960 AWT_LOGO = new class_2960("awt", "textures/gui/title/awt_logo.png");
    private static final class_2960 AWT_LOGO_XMAS = new class_2960("awt", "textures/gui/title/awt_christmas_logo.png");
    private static final class_2960 AWT_MINCERAFT_LOGO = new class_2960("awt", "textures/gui/title/awt_minceraft_logo.png");
    private static final class_2960 AWT_LOGO_LEBRON = new class_2960("awt", "textures/gui/title/awt_lebron_logo.png");
    private static final class_2960 AWT_LOGO_HALLOWEEN = new class_2960("awt", "textures/gui/title/awt_halloween_logo.png");
    @Unique
    private static final boolean IS_MINCERAFT = new Random().nextInt(1000) == 0;

    @Inject(method={"draw*"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCustomLogo(class_332 context, int screenWidth, float alpha, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        class_2960 logo = IS_MINCERAFT ? AWT_MINCERAFT_LOGO : (this.isChristmas() ? AWT_LOGO_XMAS : (this.isHalloween() ? AWT_LOGO_HALLOWEEN : (this.isLebron() ? AWT_LOGO_LEBRON : AWT_LOGO)));
        int logoWidth = 300;
        int logoHeight = 90;
        int centerX = (screenWidth - logoWidth) / 2;
        int logoY = 12;
        RenderSystem.enableBlend();
        context.method_25290(logo, centerX, logoY, 0.0f, 0.0f, logoWidth, logoHeight, logoWidth, logoHeight);
        ci.cancel();
    }

    @Unique
    private boolean isChristmas() {
        LocalDate date = LocalDate.now();
        return date.getMonth() == Month.DECEMBER && date.getDayOfMonth() == 25;
    }

    @Unique
    private boolean isLebron() {
        LocalDate date = LocalDate.now();
        return date.getMonth() == Month.DECEMBER && date.getDayOfMonth() == 30;
    }

    @Unique
    private boolean isHalloween() {
        LocalDate date = LocalDate.now();
        return date.getMonth() == Month.OCTOBER && date.getDayOfMonth() == 31;
    }
}

