/*
 * Decompiled with CFR 0.152.
 */
package kimiram.bouncingimage.config;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import kimiram.bouncingimage.BouncingImageClient;
import kimiram.bouncingimage.config.ConfigValues;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class BouncingImageConfig {
    public static Path file = Paths.get(FabricLoader.getInstance().getGameDir().toString() + "\\config\\bouncingimage.json", new String[0]);
    public static ConfigValues configValues = new ConfigValues();
    public static Gson gson = new Gson();

    public static void createFile() {
        try {
            Files.createFile(file, new FileAttribute[0]);
            String json = gson.toJson((Object)configValues);
            Files.writeString(file, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            BouncingImageClient.LOGGER.error("Failed to create bouncing image config file because: {}", (Object)e.toString());
        }
    }

    public static void readFile() {
        try {
            String json = Files.readString(file);
            configValues = (ConfigValues)gson.fromJson(json, ConfigValues.class);
        }
        catch (Exception e) {
            BouncingImageClient.LOGGER.error("Failed to read bouncing image config file because: {}", (Object)String.valueOf(e));
        }
    }

    public static void saveFile() {
        String json = gson.toJson((Object)configValues);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.writeString(file, (CharSequence)json, new OpenOption[0]);
            }
            catch (Exception e) {
                BouncingImageClient.LOGGER.error("Failed to save bouncing image config because: {}", (Object)e.toString());
            }
        } else {
            BouncingImageConfig.createFile();
        }
    }

    public static void initialize() {
        if (Files.exists(file, new LinkOption[0])) {
            BouncingImageConfig.readFile();
        } else {
            BouncingImageConfig.createFile();
        }
    }

    public static void applyImage(String link) {
        if (link != null && !link.isEmpty()) {
            try {
                URI uri = new URI(link);
                URL imageURL = uri.toURL();
                BufferedImage bufferedImage = ImageIO.read(imageURL);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                byte[] bytes = baos.toByteArray();
                class_1011 image = class_1011.method_49277((byte[])bytes);
                class_1060 textureManager = class_310.method_1551().method_1531();
                class_1043 texture = new class_1043(image);
                textureManager.method_4616(class_2960.method_60655((String)"bouncing-image", (String)"textures/bouncing_image.png"), (class_1044)texture);
                BouncingImageConfig.configValues.imageUrl = link;
            }
            catch (Exception e) {
                BouncingImageClient.LOGGER.warn("Failed to load bouncing image because: {}", (Object)e.toString());
            }
        }
    }
}

