/*
 * Decompiled with CFR 0.152.
 */
package kimiram.bouncingimage.config;

import kimiram.bouncingimage.BouncingImageClient;
import kimiram.bouncingimage.config.BouncingImageConfig;

public class CollisionBox {
    public int x1;
    public int y1;
    public int x2;
    public int y2;

    public CollisionBox(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void checkOverlaps() {
        double ix1 = BouncingImageClient.imageX;
        double iy1 = BouncingImageClient.imageY;
        double ix2 = ix1 + (double)BouncingImageConfig.configValues.imageWidth;
        double iy2 = iy1 + (double)BouncingImageConfig.configValues.imageHeight;
        if (this.isOverlap(ix1, iy1, ix2, iy2)) {
            if (this.isOverlap(ix1 - BouncingImageClient.dX * BouncingImageConfig.configValues.speed, iy1, ix2 - BouncingImageClient.dX * BouncingImageConfig.configValues.speed, iy2)) {
                BouncingImageClient.change_dY = true;
            } else if (this.isOverlap(ix1, iy1 - BouncingImageClient.dY * BouncingImageConfig.configValues.speed, ix2, iy2 - BouncingImageClient.dY * BouncingImageConfig.configValues.speed)) {
                BouncingImageClient.change_dX = true;
            } else if (Math.max(Math.abs(ix1 - (double)this.x2), Math.abs(ix2 - (double)this.x1)) > Math.max(Math.abs(iy1 - (double)this.y2), Math.abs(iy2 - (double)this.y1))) {
                BouncingImageClient.change_dX = true;
            } else if (Math.max(Math.abs(ix1 - (double)this.x2), Math.abs(ix2 - (double)this.x1)) < Math.max(Math.abs(iy1 - (double)this.y2), Math.abs(iy2 - (double)this.y1))) {
                BouncingImageClient.change_dY = true;
            } else {
                BouncingImageClient.change_dX = true;
                BouncingImageClient.change_dY = true;
            }
        }
    }

    public boolean isOverlap(double x1, double y1, double x2, double y2) {
        if ((x1 <= (double)this.x2 && x1 >= (double)this.x1 || x2 >= (double)this.x1 && x2 <= (double)this.x2) && (y1 <= (double)this.y2 && y1 >= (double)this.y1 || y2 >= (double)this.y1 && y2 <= (double)this.y2)) {
            return true;
        }
        return ((double)this.x1 <= x2 && (double)this.x1 >= x1 || (double)this.x2 >= x1 && (double)this.x2 <= x2) && ((double)this.y1 <= y2 && (double)this.y1 >= y1 || (double)this.y2 >= y1 && (double)this.y2 <= y2);
    }

    public void updatePos(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void updatePos(int width, int height) {
        this.x2 = this.x1 + width;
        this.y2 = this.y1 + height;
    }

    public void updateX(int x, int width) {
        this.x1 = x;
        this.x2 = x + width;
    }

    public void updateY(int y, int height) {
        this.y1 = y;
        this.y2 = y + height;
    }
}

