/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config.controller;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.eg_particle_interactions.common.config.controller.BlockLocationController;
import games.enchanted.eg_particle_interactions.common.config.controller.generic.GenericListControllerElement;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockLocationControllerElement
extends GenericListControllerElement<BlockOrTagLocation, BlockLocationController> {
    private static final ResourceLocation BLOCK_TAG_ICON = ResourceLocation.fromNamespaceAndPath((String)"eg_particle_interactions", (String)"block_tag_icon");

    public BlockLocationControllerElement(BlockLocationController control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
    }

    public List<BlockOrTagLocation> computeMatchingValues() {
        if (this.inputField.startsWith("#")) {
            String value = this.inputField.replace("#", "");
            List<ResourceLocation> tagResourceLocations = RegistryHelpers.getMatchingTagLocations(value, BuiltInRegistries.BLOCK).toList();
            ArrayList<BlockOrTagLocation> tagLocations = new ArrayList<BlockOrTagLocation>();
            BlockOrTagLocation validatedLoc = RegistryHelpers.validateBlockOrTagLocationWithFallback(this.inputField, null);
            this.currentItem = validatedLoc;
            if (!validatedLoc.location().getPath().isEmpty()) {
                this.matchingItems.put(validatedLoc.location(), validatedLoc);
                tagLocations.add(validatedLoc);
            }
            for (ResourceLocation tagResourceLocation : tagResourceLocations) {
                this.matchingItems.put(tagResourceLocation, validatedLoc);
                tagLocations.add(new BlockOrTagLocation(tagResourceLocation, true));
            }
            return tagLocations;
        }
        List<ResourceLocation> blockResourceLocations = RegistryHelpers.getMatchingLocations(this.inputField, BuiltInRegistries.BLOCK).toList();
        ArrayList<BlockOrTagLocation> blockOrTagLocations = new ArrayList<BlockOrTagLocation>();
        ResourceLocation validatedLoc = RegistryHelpers.validateBlockLocationWithFallback(this.inputField, null);
        this.currentItem = validatedLoc == null ? null : new BlockOrTagLocation(validatedLoc);
        for (ResourceLocation blockLocation : blockResourceLocations) {
            Block blockFromLocation = RegistryHelpers.getBlockFromLocation(blockLocation);
            if (blockFromLocation.defaultBlockState().isAir()) continue;
            this.matchingItems.put(blockLocation, new BlockOrTagLocation(RegistryHelpers.getLocationFromBlock(blockFromLocation)));
            blockOrTagLocations.add(new BlockOrTagLocation(blockLocation));
        }
        return blockOrTagLocations;
    }

    @Override
    public Item getItemToRender(BlockOrTagLocation value) {
        if (value.isTag()) {
            return null;
        }
        return RegistryHelpers.getBlockFromLocation(value.location()).asItem();
    }

    @Override
    protected void renderDropdownEntry(GuiGraphics graphics, Dimension<Integer> entryDimension, BlockOrTagLocation blockOrTagLocation) {
        super.renderDropdownEntry(graphics, entryDimension, blockOrTagLocation);
        if (blockOrTagLocation.isTag()) {
            this.renderTagIcon(graphics, (Integer)entryDimension.xLimit() - 2, (Integer)entryDimension.y() + 1);
            return;
        }
        this.renderItemIcon(graphics, this.getItemToRender(blockOrTagLocation), (Integer)entryDimension.xLimit() - 2, (Integer)entryDimension.y() + 1);
    }

    @Override
    public Component getRenderedValueText() {
        BlockOrTagLocation currentValue = (BlockOrTagLocation)((BlockLocationController)((Object)this.getController())).option().pendingValue();
        if (currentValue.isTag()) {
            return TextUtil.formatResourceLocationToChatComponent(currentValue.location(), "#");
        }
        return Component.translatable((String)RegistryHelpers.getBlockFromLocation(currentValue.location()).getDescriptionId());
    }

    @Override
    @Nullable
    public Component getHoverTooltipText() {
        BlockOrTagLocation value = (BlockOrTagLocation)((BlockLocationController)((Object)this.getController())).option().pendingValue();
        return TextUtil.formatResourceLocationToChatComponent(value.location(), value.isTag() ? "#" : "");
    }

    @Override
    protected void renderItemIcon(GuiGraphics graphics, Item item, int x, int y) {
        if (((BlockOrTagLocation)((BlockLocationController)((Object)this.getController())).option().pendingValue()).isTag()) {
            this.renderTagIcon(graphics, x, y);
            return;
        }
        super.renderItemIcon(graphics, item, x, y);
    }

    protected void renderTagIcon(GuiGraphics graphics, int x, int y) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BLOCK_TAG_ICON, x, y, 16, 16);
    }
}

