/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config.controller;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.eg_particle_interactions.common.config.controller.FluidLocationControllerElement;
import games.enchanted.eg_particle_interactions.common.config.controller.generic.AbstractFixedDropdownController;
import games.enchanted.eg_particle_interactions.common.config.controller.generic.GenericListControllerElement;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class FluidLocationController
extends AbstractFixedDropdownController<ResourceLocation> {
    public FluidLocationController(Option<ResourceLocation> option) {
        super(option);
    }

    @Override
    public String getString() {
        return ((ResourceLocation)this.option().pendingValue()).toString();
    }

    @Override
    public void setFromStringIndex(String value, int index) {
        String valueFromDropdown = this.getValueFromDropdown(index);
        if (valueFromDropdown == null) {
            valueFromDropdown = value;
        }
        ResourceLocation validatedValue = RegistryHelpers.validateFluidLocationWithFallback(valueFromDropdown, null);
        if (this.isValueValid(valueFromDropdown) && validatedValue != null) {
            this.option.requestSet((Object)validatedValue);
        }
    }

    public boolean isValueValid(String value) {
        ResourceLocation blockLocFromValue = RegistryHelpers.validateFluidLocationWithFallback(value, null);
        return blockLocFromValue != null;
    }

    protected String getValidValue(String value, int offset) {
        return RegistryHelpers.getMatchingLocations(value, BuiltInRegistries.FLUID).filter(location -> !RegistryHelpers.getFluidFromLocation(location).defaultFluidState().createLegacyBlock().isAir()).skip(offset).findFirst().map(ResourceLocation::toString).orElseGet(this::getString);
    }

    @Override
    public GenericListControllerElement<ResourceLocation, ?> createWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new FluidLocationControllerElement(this, screen, widgetDimension);
    }
}

