/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.mixin.items;

import com.llamalad7.mixinextras.sugar.Local;
import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.config.type.BrushParticleBehaviour;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverride;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={net.minecraft.world.item.BrushItem.class})
public abstract class BrushItem {
    @Inject(method={"spawnDustParticles(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/BlockHitResult;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/HumanoidArm;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/BlockHitResult;getLocation()Lnet/minecraft/world/phys/Vec3;", shift=At.Shift.AFTER)}, cancellable=true)
    private void disableOrReplaceDustParticles(Level level, BlockHitResult hitResult, BlockState blockState, Vec3 pos, HumanoidArm arm, CallbackInfo ci, @Local(ordinal=0) BrushItem.DustParticlesDelta particlesDelta, @Local(ordinal=0) int armDirection, @Local(ordinal=1) int amountOfParticles) {
        boolean isOverrideNoneOrVanilla;
        if (!level.isClientSide()) {
            return;
        }
        if (ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.DISABLED) {
            ci.cancel();
            return;
        }
        Vec3 particlePos = hitResult.getLocation();
        Logging.interactionDebugInfo("Blockstate brushed {} at {}", blockState, particlePos);
        BlockParticleOverride override = BlockParticleOverride.getOverrideForBlockState(blockState, 5);
        boolean bl = isOverrideNoneOrVanilla = override == BlockParticleOverride.VANILLA || override == BlockParticleOverride.NONE;
        if (ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_VANILLA && isOverrideNoneOrVanilla) {
            return;
        }
        Direction brushDirection = hitResult.getDirection();
        SpawnParticles.spawnBrushingParticles((ClientLevel)level, override, blockState, brushDirection, particlePos, armDirection, amountOfParticles, particlesDelta.xd(), particlesDelta.yd(), particlesDelta.zd());
        ci.cancel();
    }
}

