/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.mixin.items;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={net.minecraft.world.item.BucketItem.class})
public abstract class BucketItem {
    @Shadow
    @Final
    private Fluid content;

    @Inject(method={"playEmptySound(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private void spawnFluidParticlesOnBucketEmpty(LivingEntity livingEntity, LevelAccessor levelAccessor, BlockPos fluidPos, CallbackInfo ci) {
        if (levelAccessor.isClientSide()) {
            Fluid placedFluid = this.content;
            FluidState placedFluidState = this.content.defaultFluidState();
            if (!levelAccessor.dimensionType().ultraWarm() || !placedFluidState.is(FluidTags.WATER)) {
                Logging.interactionDebugInfo("Bucket of " + String.valueOf(placedFluid.builtInRegistryHolder().key().location()) + " placed at " + fluidPos.toShortString(), new Object[0]);
                SpawnParticles.spawnFluidPlacedParticle(levelAccessor, fluidPos, placedFluid);
            }
        }
    }
}

