/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.mixin.items;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={net.minecraft.world.item.HoeItem.class})
public abstract class HoeItem {
    @Inject(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")})
    private void spawnParticlesOnTill(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide()) {
            BlockPos tilledBlockPos = useOnContext.getClickedPos();
            BlockState blockState = level.getBlockState(tilledBlockPos);
            Logging.interactionDebugInfo("Hoe used (" + String.valueOf(this) + ") at " + tilledBlockPos.toShortString() + " on " + String.valueOf(blockState.getBlock()), new Object[0]);
            SpawnParticles.spawnHoeTillParticle(level, tilledBlockPos, useOnContext);
        }
    }
}

