/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.mixin.items;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={net.minecraft.world.item.ShovelItem.class})
public abstract class ShovelItem {
    @Inject(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")})
    private void spawnParticlesOnBlockFlatten(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide()) {
            BlockPos flattenedBlockPos = useOnContext.getClickedPos();
            BlockState blockState = level.getBlockState(flattenedBlockPos);
            Logging.interactionDebugInfo("Shovel used (" + String.valueOf(this) + ") at " + flattenedBlockPos.toShortString() + " to flatten " + String.valueOf(blockState.getBlock()), new Object[0]);
            SpawnParticles.spawnShovelFlattenParticle(level, flattenedBlockPos, useOnContext);
        }
    }
}

