/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BouncyParticle
extends CustomGeometryParticle {
    protected boolean physics_canBounce = true;
    protected float physics_bounciness = 0.85f;
    protected float physics_passThroughFluidSpeed = 1.0f;
    protected boolean isInWater = false;
    protected boolean hasEnteredWater = false;

    protected BouncyParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
    }

    protected float getTotalVelocity() {
        return (float)Math.abs(this.xd + this.yd + this.zd);
    }

    public void tick() {
        this.isInWater = this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).is(FluidTags.WATER);
        if (this.isInWater) {
            this.hasEnteredWater = true;
        }
        if (this.age > 0 && this.physics_canBounce && this.physics_bounciness > 0.0f && this.hasPhysics) {
            double zVel;
            double yVel;
            double xVel;
            if (this.isInWater) {
                this.xd *= (double)this.physics_passThroughFluidSpeed;
                this.yd *= (double)this.physics_passThroughFluidSpeed;
                this.zd *= (double)this.physics_passThroughFluidSpeed;
            }
            if (ConfigHandler.general_extraParticlePhysicsEnabled && (xVel = this.xd) * xVel + (yVel = this.yd) * yVel + (zVel = this.zd) * zVel < (double)Mth.square((int)100)) {
                Vec3 collisionVector = Entity.collideBoundingBox(null, (Vec3)new Vec3(xVel, yVel, zVel), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
                this.xd = collisionVector.x == 0.0 ? -this.xd * (double)this.physics_bounciness : collisionVector.x;
                this.yd = collisionVector.y == 0.0 ? -this.yd * (double)this.physics_bounciness : collisionVector.y;
                this.zd = collisionVector.z == 0.0 ? -this.zd * (double)this.physics_bounciness : collisionVector.z;
            }
        }
        super.tick();
    }
}

