/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.compat;

import com.mojang.blaze3d.vertex.VertexConsumer;
import games.enchanted.eg_particle_interactions.common.rendering.particle.ModParticleRenderTypes;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.VertexQuadConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class CustomGeometryParticle
extends Particle {
    protected float scale;
    protected float roll;
    protected float oRoll;
    protected TextureAtlasSprite sprite;
    protected float rCol = 1.0f;
    protected float gCol = 1.0f;
    protected float bCol = 1.0f;
    protected float alpha = 1.0f;

    protected CustomGeometryParticle(ClientLevel clientLevel, double x, double y, double z, TextureAtlasSprite textureAtlasSprite) {
        this(clientLevel, x, y, z, 0.0, 0.0, 0.0, textureAtlasSprite);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    protected CustomGeometryParticle(ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite textureAtlasSprite) {
        super(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprite = textureAtlasSprite;
        this.scale = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        ParticleLayer layer = this.getParticleLayer();
        if (layer == null) {
            return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
        }
        return layer.layer;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        this.renderTick(partialTicks);
        Quaternionf quaternionf = new Quaternionf();
        this.getBillboardMode().rotate(quaternionf, camera, partialTicks);
        if (this.roll != 0.0f) {
            quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        VertexQuadConsumer consumer = new VertexQuadConsumer(vertexConsumer);
        this.adjustPositionBeforeExtraction(consumer, camera, quaternionf, partialTicks);
    }

    protected void adjustPositionBeforeExtraction(QuadConsumer consumer, Camera camera, Quaternionf quaternionf, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z());
        this.extractGeometry(consumer, quaternionf, x, y, z, partialTicks);
    }

    protected void extractGeometry(QuadConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        int light = this.getLightColor(partialTicks);
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, 1.0f, -1.0f, this.getScale(), this.getU1(), this.getV1(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.addVertex(quaternion, x, y, z, 1.0f, 1.0f, this.getScale(), this.getU1(), this.getV0(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.addVertex(quaternion, x, y, z, -1.0f, 1.0f, this.getScale(), this.getU0(), this.getV0(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.addVertex(quaternion, x, y, z, -1.0f, -1.0f, this.getScale(), this.getU0(), this.getV1(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.finishQuad();
    }

    public BillboardMode getBillboardMode() {
        return BillboardMode.XYZ;
    }

    protected void renderTick(float partialTicks) {
    }

    public void setSpriteFromAge(SpriteSet sprites) {
        if (this.removed) {
            return;
        }
        this.setSprite(sprites.get(this.age, this.lifetime));
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public AABB getCullingBox(float partialTicks) {
        return this.getBoundingBox();
    }

    protected float getU0() {
        return this.sprite.getU0();
    }

    protected float getU1() {
        return this.sprite.getU1();
    }

    protected float getV0() {
        return this.sprite.getV0();
    }

    protected float getV1() {
        return this.sprite.getV1();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    protected abstract ParticleLayer getParticleLayer();

    public static enum ParticleLayer {
        OPAQUE(ParticleRenderType.PARTICLE_SHEET_OPAQUE),
        TERRAIN(ParticleRenderType.TERRAIN_SHEET),
        TRANSLUCENT(ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT),
        BACKFACE_TERRAIN(ModParticleRenderTypes.BACKFACE_TERRAIN_PARTICLE);

        public final ParticleRenderType layer;

        private ParticleLayer(ParticleRenderType layer) {
            this.layer = layer;
        }
    }

    public static interface BillboardMode {
        public static final BillboardMode FIXED = (quaternion, camera, partialTicks) -> quaternion.set(0.0f, 0.0f, 0.0f, camera.rotation().w);
        public static final BillboardMode XYZ = (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)camera.rotation());

        public void rotate(Quaternionf var1, Camera var2, float var3);
    }
}

