/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.constant_motion;

import games.enchanted.eg_particle_interactions.common.particle.constant_motion.ConstantMotionAnimatedParticle;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class LavaPop
extends ConstantMotionAnimatedParticle {
    protected LavaPop(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, int lifetime, float quadSize, boolean transparency) {
        super(level, x, y, z, spriteSet, lifetime, quadSize, transparency);
    }

    @Override
    protected void extractGeometry(QuadConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float scale = this.getScale();
        int packedLight = this.getLightColor(partialTicks);
        float uo = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, 1.0f, 0.0f, scale, u1, v1, packedLight);
        consumer.addVertex(quaternion, x, y, z, 1.0f, 2.0f, scale, u1, v0, packedLight);
        consumer.addVertex(quaternion, x, y, z, -1.0f, 2.0f, scale, uo, v0, packedLight);
        consumer.addVertex(quaternion, x, y, z, -1.0f, 0.0f, scale, uo, v1, packedLight);
        consumer.finishQuad();
    }

    public static class LavaPopProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public LavaPopProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LavaPop(level, x, y, z, this.spriteSet, MathHelpers.randomBetween(26, 32), 0.25f, false);
        }
    }
}

