/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.emitter;

import com.mojang.blaze3d.vertex.VertexConsumer;
import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEmitterParticle
extends Particle {
    protected float emitterWidth;
    protected float emitterHeight;
    protected float emitterDepth;

    public AbstractEmitterParticle(ClientLevel level, double x, double y, double z, float width, float height, float depth) {
        super(level, x, y, z);
        this.emitterWidth = width;
        this.emitterHeight = height;
        this.emitterDepth = depth;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        if (ConfigHandler.debug_showEmitterBounds) {
            this.level.addParticle((ParticleOptions)new DustParticleOptions(-65536, 0.5f), this.x, this.y, this.z, 0.0, 0.0, 0.0);
            this.level.addParticle((ParticleOptions)new DustParticleOptions(-16711936, 0.5f), this.x + (double)this.emitterWidth, this.y + (double)this.emitterHeight, this.z + (double)this.emitterDepth, 0.0, 0.0, 0.0);
        }
        this.emitterTick();
    }

    protected abstract void emitterTick();

    @Nullable
    protected abstract ParticleOptions getParticleToEmit(ClientLevel var1, double var2, double var4, double var6);

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float v) {
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }
}

