/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.emitter.random_distribution;

import games.enchanted.eg_particle_interactions.common.particle.emitter.AbstractEmitterParticle;
import games.enchanted.eg_particle_interactions.common.particle.option.RandomDistributionEmitterOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import org.joml.Vector3f;

public abstract class AbstractRandomDistributionEmitter
extends AbstractEmitterParticle {
    protected double emittedXSpeed;
    protected double emittedYSpeed;
    protected double emittedZSpeed;
    protected int emitterInterval;
    protected int emitterIterations;
    protected int particlesPerEmission;
    protected Vector3f emitterVariance;
    protected boolean emitOnFirstTick;

    protected AbstractRandomDistributionEmitter(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomDistributionEmitterOptions emitterOptions) {
        super(level, x, y, z, emitterOptions.getDimensions().x, emitterOptions.getDimensions().y, emitterOptions.getDimensions().z);
        this.emittedXSpeed = xSpeed;
        this.emittedYSpeed = ySpeed;
        this.emittedZSpeed = zSpeed;
        this.emitterInterval = emitterOptions.getTickInterval();
        this.emitterIterations = emitterOptions.getRepeat();
        this.particlesPerEmission = emitterOptions.getParticlesPerEmission();
        this.emitOnFirstTick = emitterOptions.getEmitOnFirstTick();
        this.emitterVariance = emitterOptions.getVelocityVariance();
        this.setLifetime(this.emitterInterval * this.emitterIterations);
        this.x -= (double)(this.emitterWidth / 2.0f);
        this.y -= (double)(this.emitterHeight / 2.0f);
        this.z -= (double)(this.emitterDepth / 2.0f);
    }

    @Override
    protected void emitterTick() {
        if ((this.age - (this.emitOnFirstTick ? 1 : 0)) % this.emitterInterval == 0) {
            for (int i = 0; i < this.particlesPerEmission; ++i) {
                double[] emitPos = this.getRandomPositionInsideBounds();
                ParticleOptions particle = this.getParticleToEmit(this.level, emitPos[0], emitPos[1], emitPos[2]);
                if (particle == null) continue;
                this.level.addParticle(particle, emitPos[0], emitPos[1], emitPos[2], this.emittedXSpeed + (double)(this.level.random.nextFloat() * this.emitterVariance.x - this.emitterVariance.x / 2.0f), this.emittedYSpeed + (double)(this.level.random.nextFloat() * this.emitterVariance.y - this.emitterVariance.y / 2.0f), this.emittedZSpeed + (double)(this.level.random.nextFloat() * this.emitterVariance.z - this.emitterVariance.z / 2.0f));
            }
        }
    }

    protected double[] getRandomPositionInsideBounds() {
        double newX = this.x + (double)(this.emitterWidth * this.level.random.nextFloat());
        double newY = this.y + (double)(this.emitterHeight * this.level.random.nextFloat());
        double newZ = this.z + (double)(this.emitterDepth * this.level.random.nextFloat());
        return new double[]{newX, newY, newZ};
    }
}

