/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.falling_spin;

import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import games.enchanted.eg_particle_interactions.common.particle.falling_spin.FallingSpinningParticle;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FallingSpinningColouredParticle
extends FallingSpinningParticle {
    protected FallingSpinningColouredParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, BlockPos blockPos, BlockState blockState, SpriteSet spriteSet, float gravityMultiplier) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier);
        int tintColour = Minecraft.getInstance().getBlockColors().getColor(blockState, (BlockAndTintGetter)level, blockPos, 0);
        int[] tintColourARGB = ColourUtil.RGBint_to_ARGB(tintColour);
        int[] averageTextureColourARGB = ColourUtil.getRandomBlockColour(blockState, tintColourARGB);
        this.rCol = (float)averageTextureColourARGB[1] / 255.0f;
        this.gCol = (float)averageTextureColourARGB[2] / 255.0f;
        this.bCol = (float)averageTextureColourARGB[3] / 255.0f;
        this.alpha = (float)averageTextureColourARGB[0] / 255.0f;
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        if ((double)this.alpha < 0.99) {
            return CustomGeometryParticle.ParticleLayer.TRANSLUCENT;
        }
        return super.getParticleLayer();
    }

    public static class SugarCaneProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public SugarCaneProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 2.5f);
            float particleSize = level.random.nextBoolean() ? 0.11f : 0.13f;
            particle.setScale(particleSize);
            particle.setSize(particleSize, particleSize);
            return particle;
        }
    }

    public static class ChainSnapProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public ChainSnapProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 3.0f);
            float particleSize = level.random.nextBoolean() ? 0.14f : 0.15f;
            particle.setScale(particleSize);
            particle.setSize(particleSize, particleSize);
            particle.maxSpinSpeed = 0.2f;
            particle.spinAcceleration = (float)Math.toRadians(level.random.nextBoolean() ? -1.0 : 1.0);
            return particle;
        }
    }

    public static class HeavyGrassBladeProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public HeavyGrassBladeProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 2.0f);
            float particleSize = level.random.nextBoolean() ? 0.1f : 0.12f;
            particle.setScale(particleSize);
            particle.setSize(particleSize, particleSize);
            return particle;
        }
    }

    public static class GrassBladeProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public GrassBladeProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 1.0f);
            float particleSize = level.random.nextBoolean() ? 0.1f : 0.12f;
            particle.setScale(particleSize);
            particle.setSize(particleSize, particleSize);
            return particle;
        }
    }

    public static class FlowerPetalProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public FlowerPetalProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 1.0f);
            particle.maxSpinSpeed = 0.5f;
            return particle;
        }
    }

    public static class TintedLeafProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public TintedLeafProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 1.0f);
            float particleSize = level.random.nextBoolean() ? 0.1f : 0.15f;
            particle.setScale(particleSize);
            particle.maxSpinSpeed = 0.5f;
            particle.setSize(particleSize, particleSize);
            return particle;
        }
    }
}

