/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.option;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcEmitterOptions
implements ParticleOptions {
    public static final int TICK_INTERVAL_DEFAULT = 1;
    public static final int REPEAT_DEFAULT = 5;
    private final ParticleType<ArcEmitterOptions> type;
    private final int length;
    private final int splits;
    private final int angleVariance;
    private final int tickInterval;
    private final int repeat;
    @Nullable
    private final Integer initialAngleXDeg;
    @Nullable
    private final Integer initialAngleYDeg;

    public ArcEmitterOptions(ParticleType<ArcEmitterOptions> type, int length, int splits, int angleVariance) {
        this(type, length, splits, angleVariance, 5, 1, null, null);
    }

    public ArcEmitterOptions(ParticleType<ArcEmitterOptions> type, int length, int splits, int angleVariance, int repeat, int tickInterval, @Nullable Integer initialAngleXDeg, @Nullable Integer initialAngleYDeg) {
        this.type = type;
        this.length = length;
        this.splits = splits;
        this.angleVariance = angleVariance;
        this.repeat = repeat;
        this.tickInterval = tickInterval;
        this.initialAngleXDeg = initialAngleXDeg;
        this.initialAngleYDeg = initialAngleYDeg;
    }

    private static Codec<ArcEmitterOptions> createCodec(ParticleType<ArcEmitterOptions> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("length", (Object)5).forGetter(ArcEmitterOptions::getLength), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("splits", (Object)2).forGetter(ArcEmitterOptions::getSplits), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("angle_variance", (Object)45).forGetter(ArcEmitterOptions::getAngleVariance), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("repeat", (Object)5).forGetter(ArcEmitterOptions::getRepeat), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("interval", (Object)1).forGetter(ArcEmitterOptions::getTickInterval), (App)Codec.INT.optionalFieldOf("initial_x_angle").forGetter(ArcEmitterOptions::getInitialAngleXDeg), (App)Codec.INT.optionalFieldOf("initial_y_angle").forGetter(ArcEmitterOptions::getInitialAngleYDeg)).apply((Applicative)instance, (length, splits, angleVariance, repeat, tickInterval, initialAngleXDeg, initialAngleYDeg) -> new ArcEmitterOptions(type, (int)length, (int)splits, (int)angleVariance, (int)repeat, (int)tickInterval, initialAngleXDeg.orElse(null), initialAngleYDeg.orElse(null))));
    }

    public static MapCodec<ArcEmitterOptions> codec(ParticleType<ArcEmitterOptions> type) {
        return ArcEmitterOptions.createCodec(type).fieldOf("emitter_options");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ArcEmitterOptions> streamCodec(ParticleType<ArcEmitterOptions> type) {
        return ByteBufCodecs.fromCodec(ArcEmitterOptions.createCodec(type));
    }

    @NotNull
    public ParticleType<ArcEmitterOptions> getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getSplits() {
        return this.splits;
    }

    public int getAngleVariance() {
        return this.angleVariance;
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public Optional<Integer> getInitialAngleXDeg() {
        return Optional.ofNullable(this.initialAngleXDeg);
    }

    public Optional<Integer> getInitialAngleYDeg() {
        return Optional.ofNullable(this.initialAngleYDeg);
    }
}

