/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.option;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public class DripParticleOption
implements ParticleOptions {
    public static final int DEFAULT_START_FALLING_TICKS = 5;
    public static final float DEFAULT_GRAVITY = 0.05f;
    public static final float DEFAULT_GRAVITY_RANDOMNESS = 0.0f;
    public static final DripParticleOption FALLING_HONEY_DROP = new DripParticleOption(ModParticleTypes.HONEY_DROP, 0, 0.02f, 0.03f);
    public static final DripParticleOption HANGING_HONEY_DROP = new DripParticleOption(ModParticleTypes.HONEY_DROP, 30, 0.02f, 0.03f);
    private final ParticleType<DripParticleOption> type;
    private final int startFallingTicks;
    private final float gravity;
    private final float gravityRandomness;

    public DripParticleOption(ParticleType<DripParticleOption> type, int fallTicks, float gravity, float gravityRandomness) {
        this.type = type;
        this.startFallingTicks = fallTicks;
        this.gravity = gravity;
        this.gravityRandomness = gravityRandomness;
    }

    private static Codec<DripParticleOption> createCodec(ParticleType<DripParticleOption> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("start_falling_ticks", (Object)5).forGetter(DripParticleOption::getStartFallingTicks), (App)Codec.FLOAT.optionalFieldOf("gravity", (Object)Float.valueOf(0.05f)).forGetter(DripParticleOption::getGravity), (App)Codec.FLOAT.optionalFieldOf("gravity_randomess", (Object)Float.valueOf(0.0f)).forGetter(DripParticleOption::getGravity)).apply((Applicative)instance, (fallTicks, gravity, gravityRandomness) -> new DripParticleOption(type, (int)fallTicks, gravity.floatValue(), gravityRandomness.floatValue())));
    }

    public static MapCodec<DripParticleOption> codec(ParticleType<DripParticleOption> type) {
        return DripParticleOption.createCodec(type).fieldOf("drip_options");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, DripParticleOption> streamCodec(ParticleType<DripParticleOption> type) {
        return ByteBufCodecs.fromCodec(DripParticleOption.createCodec(type));
    }

    @NotNull
    public ParticleType<?> getType() {
        return this.type;
    }

    public int getStartFallingTicks() {
        return this.startFallingTicks;
    }

    public float getGravity() {
        return this.gravity;
    }

    public float getGravityRandomness() {
        return this.gravityRandomness;
    }
}

