/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.shatter;

import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import games.enchanted.eg_particle_interactions.common.util.TextureHelpers;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractShatter
extends CustomGeometryParticle {
    protected final float slice0X;
    protected final float slice0Y;
    protected final float slice1X;
    protected final float slice1Y;
    protected final float uvScale;
    protected final float uvOffset;
    protected final boolean inverseSlicePositions;

    protected AbstractShatter(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, TextureHelpers.getDebugSprite());
        int spriteWidth = this.sprite.contents().width();
        int randomSize = MathHelpers.randomBetween(3, 5);
        int randomSizeThird = randomSize / 3;
        this.uvOffset = (float)MathHelpers.randomBetween(0, spriteWidth - randomSize) / (float)spriteWidth;
        this.uvScale = (float)randomSize / (float)spriteWidth;
        this.slice0X = (float)MathHelpers.randomBetween(1, randomSizeThird) / (float)randomSize;
        this.slice0Y = (float)MathHelpers.randomBetween(2, randomSizeThird) / (float)randomSize;
        this.slice1X = (float)MathHelpers.randomBetween(randomSizeThird * 2 + 1, randomSize - 1) / (float)randomSize;
        this.slice1Y = (float)MathHelpers.randomBetween(randomSizeThird * 2 - 1, randomSize - 1) / (float)randomSize;
        this.inverseSlicePositions = level.random.nextBoolean();
        this.oRoll = this.roll = (float)Math.toRadians(MathHelpers.randomBetween(0, 3) * 90);
        this.setInitialVelocity(xSpeed, ySpeed, zSpeed, 0.1f);
        this.gravity = MathHelpers.randomBetween(0.75f, 0.9f);
        this.lifetime = MathHelpers.randomBetween(5, 25);
    }

    protected void setInitialVelocity(double xSpeed, double ySpeed, double zSpeed, float variance) {
        this.xd = xSpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
        this.yd = ySpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
        this.zd = zSpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
    }

    public void tick() {
        this.xd *= (double)0.95f;
        this.yd *= (double)0.95f;
        this.zd *= (double)0.95f;
        super.tick();
    }

    @Override
    protected void renderTick(float partialTicks) {
        float percentageAge = (float)this.age / (float)this.lifetime;
        if ((double)percentageAge > 0.8) {
            float finalA = 1.0f - (Mth.lerp((float)partialTicks, (float)this.age, (float)((float)this.age + 1.0f)) / (float)this.lifetime - 0.8f) * 5.0f;
            if (finalA < 0.0f) {
                this.alpha = 0.0f;
                return;
            }
            this.alpha = finalA;
        }
    }

    protected float getParticleScale(float partialTicks) {
        return this.uvScale;
    }

    @Nullable
    protected Direction getParticleFacingDirection() {
        return null;
    }

    @Override
    public CustomGeometryParticle.BillboardMode getBillboardMode() {
        Direction facingDirection;
        Direction direction = facingDirection = this.getParticleFacingDirection();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "EAST", "SOUTH", "WEST", "UP", "DOWN"}, (Direction)direction, n)) {
            case 0: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(270.0), 0.0f));
            }
            case 1: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(180.0), 0.0f));
            }
            case 2: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), 0.0f));
            }
            case 3: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, 0.0f, 0.0f));
            }
            case 4: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(90.0)));
            }
            case 5: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(-90.0)));
            }
        }
        return CustomGeometryParticle.BillboardMode.XYZ;
    }

    protected float getScaledUVCoord(float uv) {
        return uv * this.uvScale + this.uvOffset;
    }

    @Override
    protected void extractGeometry(QuadConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        int lightColour = this.getLightColor(partialTicks);
        float u0 = this.sprite.getU(this.getScaledUVCoord(0.0f));
        float u1 = this.sprite.getU(this.getScaledUVCoord(this.slice0X));
        float v0 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f - this.slice0Y : 0.0f));
        float v1 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f : this.slice0Y));
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, this.slice0X, this.inverseSlicePositions ? 0.0f : 1.0f - this.slice0Y, scale, u1, v1, lightColour);
        consumer.addVertex(quaternion, x, y, z, this.slice0X, this.inverseSlicePositions ? this.slice0Y : 1.0f, scale, u1, v0, lightColour);
        consumer.addVertex(quaternion, x, y, z, 0.0f, this.inverseSlicePositions ? this.slice0Y : 1.0f, scale, u0, v0, lightColour);
        consumer.addVertex(quaternion, x, y, z, 0.0f, this.inverseSlicePositions ? 0.0f : 1.0f - this.slice0Y, scale, u0, v1, lightColour);
        consumer.finishQuad();
        scale = this.getParticleScale(partialTicks);
        u0 = this.sprite.getU(this.getScaledUVCoord(this.slice0X));
        u1 = this.sprite.getU(this.getScaledUVCoord(this.slice1X));
        v0 = this.sprite.getV(this.getScaledUVCoord(0.0f));
        v1 = this.sprite.getV(this.getScaledUVCoord(1.0f));
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, this.slice1X, 0.0f, scale, u1, v1, lightColour);
        consumer.addVertex(quaternion, x, y, z, this.slice1X, 1.0f, scale, u1, v0, lightColour);
        consumer.addVertex(quaternion, x, y, z, this.slice0X, 1.0f, scale, u0, v0, lightColour);
        consumer.addVertex(quaternion, x, y, z, this.slice0X, 0.0f, scale, u0, v1, lightColour);
        consumer.finishQuad();
        scale = this.getParticleScale(partialTicks);
        u0 = this.sprite.getU(this.getScaledUVCoord(this.slice1X));
        u1 = this.sprite.getU(this.getScaledUVCoord(1.0f));
        v0 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 0.0f : this.slice1Y));
        v1 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f - this.slice1Y : 1.0f));
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, 1.0f, this.inverseSlicePositions ? this.slice1Y : 0.0f, scale, u1, v1, lightColour);
        consumer.addVertex(quaternion, x, y, z, 1.0f, this.inverseSlicePositions ? 1.0f : 1.0f - this.slice1Y, scale, u1, v0, lightColour);
        consumer.addVertex(quaternion, x, y, z, this.slice1X, this.inverseSlicePositions ? 1.0f : 1.0f - this.slice1Y, scale, u0, v0, lightColour);
        consumer.addVertex(quaternion, x, y, z, this.slice1X, this.inverseSlicePositions ? this.slice1Y : 0.0f, scale, u0, v1, lightColour);
        consumer.finishQuad();
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        return CustomGeometryParticle.ParticleLayer.BACKFACE_TERRAIN;
    }
}

