/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.spark;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.StretchyBouncyShapeParticle;
import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import games.enchanted.eg_particle_interactions.common.shapes.ShapeDefinitions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlyingSpark
extends StretchyBouncyShapeParticle {
    private final SpriteSet sprites;
    private boolean isSoul;
    protected boolean hasSpawnedSmokeParticle = false;
    private static final int SPARK_UNDERWATER_DECAY_SPEED = 3;

    protected FlyingSpark(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float gravity, int lifetime, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.get(level.random));
        this.gravity = gravity;
        this.friction = 1.0f;
        this.xd = xSpeed / 2.0 + (Math.random() * 3.0 - 1.5) * (double)0.05f * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.yd = ySpeed / 2.0 + (Math.random() * 3.0 - 1.5) * (double)0.05f * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.zd = zSpeed / 2.0 + (Math.random() * 3.0 - 1.5) * (double)0.05f * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.physics_bounciness = 0.8f;
        this.physics_passThroughFluidSpeed = 0.93f;
        this.lifetime = lifetime;
        float particleSize = this.random.nextBoolean() ? 0.025f : 0.03f;
        this.setSize(particleSize, particleSize);
        this.setScale(particleSize);
        this.sprites = spriteSet;
        this.setSpriteFromAge(this.sprites);
        this.setShape(ShapeDefinitions.VERTICAL_CROSS);
        this.particleShapeScale.x = Mth.randomBetween((RandomSource)level.random, (float)0.4f, (float)1.1f);
        this.particleShapeScale.z = Mth.randomBetween((RandomSource)level.random, (float)0.4f, (float)1.1f);
        this.isSoul = false;
    }

    protected FlyingSpark(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float gravity, int lifetime, SpriteSet spriteSet, boolean isSoul) {
        this(level, x, y, z, xSpeed, ySpeed, zSpeed, gravity, lifetime, spriteSet);
        this.isSoul = isSoul;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.age < 0 || this.removed) {
            return;
        }
        this.setSpriteFromAge(this.sprites);
        float percentageTimeUntilDeath = (float)this.age / (float)this.lifetime;
        if (ConfigHandler.particle_sparks_additionalFlashEffects && !this.hasEnteredWater && (this.random.nextFloat() > percentageTimeUntilDeath + 0.8f || this.random.nextFloat() < 0.01f && this.isParticleMoving())) {
            this.level.addParticle((ParticleOptions)(this.isSoul ? ModParticleTypes.SOUL_SPARK_FLASH : ModParticleTypes.SPARK_FLASH), this.prevPrevX, this.prevPrevY, this.prevPrevZ, 0.0, 0.0, 0.0);
        }
        if (!ConfigHandler.particle_sparks_waterEvaporation) {
            this.hasSpawnedSmokeParticle = true;
        }
        if (this.hasEnteredWater && !this.hasSpawnedSmokeParticle) {
            this.level.addParticle((ParticleOptions)ModParticleTypes.WATER_VAPOUR, this.xo, this.yo, this.zo, this.xd / 6.0, -this.yd / 2.0, this.zd / 6.0);
            this.level.playLocalSound(this.xo, this.yo, this.zo, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.AMBIENT, 0.15f, 1.2f, false);
            this.hasSpawnedSmokeParticle = true;
        }
    }

    protected int getShortenedAge() {
        return Math.clamp((long)this.age * (long)(this.hasEnteredWater ? 3 : 1), 0, this.lifetime);
    }

    @Override
    public void setSpriteFromAge(@NotNull SpriteSet sprite) {
        if (!this.removed) {
            int adjustedAge = this.getShortenedAge();
            this.setSprite(sprite.get(adjustedAge, this.lifetime));
        }
    }

    public int getLightColor(float partialTicks) {
        int adjustedAge = this.getShortenedAge();
        float percentageTimeAlive = Math.abs(1.0f - (float)adjustedAge / (float)this.lifetime);
        int sparkLight = (int)(percentageTimeAlive * 15.0f);
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        int blockLight = this.level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = this.level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)Math.max(blockLight, sparkLight), (int)skyLight);
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        return CustomGeometryParticle.ParticleLayer.OPAQUE;
    }

    public static class FloatingSoulSparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FloatingSoulSparkProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, Mth.randomBetween((RandomSource)level.random, (float)0.2f, (float)0.3f), Mth.randomBetweenInclusive((RandomSource)level.random, (int)4, (int)12), this.spriteSet, true);
        }
    }

    public static class FlyingSoulSparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FlyingSoulSparkProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)0.9f), Mth.randomBetweenInclusive((RandomSource)level.random, (int)20, (int)60), this.spriteSet, true);
        }
    }

    public static class FloatingSparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FloatingSparkProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, Mth.randomBetween((RandomSource)level.random, (float)0.2f, (float)0.3f), Mth.randomBetweenInclusive((RandomSource)level.random, (int)4, (int)12), this.spriteSet);
        }
    }

    public static class FlyingSparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FlyingSparkProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)0.9f), Mth.randomBetweenInclusive((RandomSource)level.random, (int)20, (int)60), this.spriteSet);
        }
    }
}

