/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.spark;

import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SparkFlash
extends CustomGeometryParticle {
    private final SpriteSet sprites;
    private final float originalQuadSize;
    protected int prevAge;
    protected final boolean useRandomAnimation;

    SparkFlash(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, boolean useRandomAnimation) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites.get(0, 1));
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.96f;
        this.xd = xSpeed / 2.0 + (Math.random() * 3.0 - 1.5) * 0.07 * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.yd = ySpeed / 2.0 + (Math.random() * 3.0 - 1.5) * 0.07 * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.zd = zSpeed / 2.0 + (Math.random() * 3.0 - 1.5) * 0.07 * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.useRandomAnimation = useRandomAnimation;
        if (useRandomAnimation) {
            int rot = this.random.nextIntBetweenInclusive(0, 3);
            this.oRoll = this.roll = (float)(rot * 90);
        }
        this.lifetime = this.random.nextInt(4) + 3;
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
        this.setScale(0.125f);
        this.originalQuadSize = this.getScale();
        this.prevAge = this.age;
    }

    public void tick() {
        this.prevAge = this.age;
        super.tick();
        if (this.useRandomAnimation) {
            this.setSprite(this.sprites.get(this.random));
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    public int getLightColor(float f) {
        return 240;
    }

    @Override
    protected void renderTick(float partialTicks) {
        this.setScale(this.originalQuadSize * (0.5f + Math.abs(1.0f - Mth.lerp((float)partialTicks, (float)this.prevAge, (float)this.age) / (float)this.lifetime) * 0.5f));
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        return CustomGeometryParticle.ParticleLayer.OPAQUE;
    }

    public static class RandomAnimationProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public RandomAnimationProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SparkFlash(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, true);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SparkFlash(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, false);
        }
    }
}

