/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.splash;

import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class BucketSplash
extends CustomGeometryParticle {
    protected BucketSplash(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.gravity = 0.95f;
        this.friction = 0.999f;
        this.xd = xSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = ySpeed + (Math.random() - 0.5) * (double)(this.random.nextFloat() * 0.5f - 0.3f);
        this.zd = zSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        float particleSize = 0.1355f - (this.random.nextBoolean() ? 0.01f : 0.0f);
        this.setScale(particleSize);
        this.setSize(particleSize, particleSize);
    }

    public void tick() {
        super.tick();
        if (!this.removed && this.onGround && this.random.nextFloat() > 0.9f) {
            this.randomOnParticleLand();
        }
    }

    public void randomOnParticleLand() {
        this.remove();
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        return CustomGeometryParticle.ParticleLayer.TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BucketSplash(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet.get(level.random));
        }
    }
}

