/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.splash;

import games.enchanted.eg_particle_interactions.common.particle.splash.BucketSplash;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ColouredBucketSplash
extends BucketSplash {
    protected ColouredBucketSplash(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, BlockPos blockPos, BlockState blockState, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.get(level.random));
        int tintColour = Minecraft.getInstance().getBlockColors().getColor(blockState, (BlockAndTintGetter)level, blockPos, 0);
        this.rCol *= (float)(tintColour >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(tintColour >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(tintColour & 0xFF) / 255.0f;
    }

    public static class Provider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ColouredBucketSplash(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet);
        }
    }
}

