/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.swirling;

import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;

public class SwirlingParticle
extends CustomGeometryParticle {
    protected float rotSpeed;
    protected float spinAcceleration;
    protected double swirlPeriod;
    protected float swirlStrength;
    protected final boolean shouldSwirl;

    protected SwirlingParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, boolean shouldSwirl) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.get(level.random));
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.gravity = 0.5f;
        this.sprite = spriteSet.get(level.random);
        this.lifetime = 100;
        this.setScale(0.1875f);
        this.shouldSwirl = shouldSwirl;
        this.rotSpeed = 0.0f;
        this.spinAcceleration = 0.0f;
        this.swirlStrength = MathHelpers.randomBetween(5, 5);
        this.swirlPeriod = MathHelpers.randomBetween(100, 300);
    }

    protected void setInitialVelocity(double xSpeed, double ySpeed, double zSpeed, float variance) {
        this.xd = xSpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
        this.yd = ySpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
        this.zd = zSpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
    }

    public void applyGravity() {
        this.yd -= (double)(0.04f * this.gravity);
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        return CustomGeometryParticle.ParticleLayer.OPAQUE;
    }

    public void tick() {
        if (this.removed) {
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        double swirlX = 0.0;
        double swirlZ = 0.0;
        if (this.shouldSwirl) {
            float swirlMultiplier = (float)this.age * 0.08f;
            swirlX += (double)swirlMultiplier * Math.cos((double)swirlMultiplier * this.swirlPeriod) * (double)this.swirlStrength;
            swirlZ += (double)swirlMultiplier * Math.sin((double)swirlMultiplier * this.swirlPeriod) * (double)this.swirlStrength;
        }
        this.xd += swirlX * (double)0.0025f;
        this.zd += swirlZ * (double)0.0025f;
        this.applyGravity();
        this.move(this.xd, this.yd, this.zd);
        this.rotSpeed += this.spinAcceleration / 20.0f;
        this.oRoll = this.roll;
        this.roll += this.rotSpeed / 20.0f;
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
    }
}

