/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle_override;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FluidPlacementParticle {
    NONE("none"),
    TINTED_WATER("tinted_water", ModParticleTypes.WATER_BUCKET_TINTED_SPLASH, true),
    LAVA("lava", (ParticleOptions)ModParticleTypes.LAVA_BUCKET_SPLASH, false),
    GENERIC("generic", ModParticleTypes.GENERIC_FLUID_BUCKET_SPLASH, true);

    private final String name;
    @Nullable
    private ParticleOptions particleType;
    @Nullable
    private ParticleType<BlockParticleOption> blockParticleType;
    private final boolean isBlockStateParticle;

    private FluidPlacementParticle(String overrideName, boolean isBlockStateParticle) {
        this.name = overrideName;
        this.isBlockStateParticle = isBlockStateParticle;
    }

    private FluidPlacementParticle(String overrideName) {
        this(overrideName, false);
        this.particleType = null;
        this.blockParticleType = null;
    }

    private FluidPlacementParticle(String overrideName, ParticleOptions particle, boolean isBlockStateParticle) {
        this(overrideName, isBlockStateParticle);
        this.particleType = particle;
        this.blockParticleType = null;
    }

    private FluidPlacementParticle(String overrideName, ParticleType<BlockParticleOption> particle, boolean isBlockStateParticle) {
        this(overrideName, isBlockStateParticle);
        this.particleType = null;
        this.blockParticleType = particle;
    }

    @Nullable
    public ParticleOptions getParticleOption() {
        return this.particleType;
    }

    @Nullable
    public BlockParticleOption getBlockParticleOption(BlockState blockState) {
        if (this.blockParticleType == null) {
            return null;
        }
        return new BlockParticleOption(this.blockParticleType, blockState);
    }

    public boolean isBlockStateParticle() {
        return this.isBlockStateParticle;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public static FluidPlacementParticle getParticleForFluid(Fluid fluid) {
        return FluidPlacementParticle.getParticleForFluid(fluid, true);
    }

    public static FluidPlacementParticle getParticleForFluid(Fluid fluid, boolean isFluidBeingPlaced) {
        ResourceLocation fluidLoc = RegistryHelpers.getLocationFromFluid(fluid);
        if (ConfigHandler.tintedWaterSplash_fluids.contains(fluidLoc) && FluidPlacementParticle.shouldHaveParticle(isFluidBeingPlaced, ConfigHandler.tintedWaterSplash_onPlace)) {
            return TINTED_WATER;
        }
        if (ConfigHandler.lavaSplash_fluids.contains(fluidLoc) && FluidPlacementParticle.shouldHaveParticle(isFluidBeingPlaced, ConfigHandler.lavaSplash_onPlace)) {
            return LAVA;
        }
        if (ConfigHandler.genericSplash_fluids.contains(fluidLoc) && FluidPlacementParticle.shouldHaveParticle(isFluidBeingPlaced, ConfigHandler.genericSplash_onPlace)) {
            return GENERIC;
        }
        return NONE;
    }

    private static boolean shouldHaveParticle(boolean isFluidBeingPlaced, boolean spawnOnFluidPlace) {
        if (isFluidBeingPlaced) {
            return spawnOnFluidPlace;
        }
        return false;
    }

    public static int getParticleMultiplier(FluidPlacementParticle fluidPlacementParticle, boolean isBlockBeingPlaced) {
        switch (fluidPlacementParticle.ordinal()) {
            case 1: {
                return FluidPlacementParticle.getAppropriateMultiplier(isBlockBeingPlaced, ConfigHandler.maxTintedWaterSplash_onPlace, 0);
            }
            case 2: {
                return FluidPlacementParticle.getAppropriateMultiplier(isBlockBeingPlaced, ConfigHandler.maxLavaSplash_onPlace, 0);
            }
            case 3: {
                return FluidPlacementParticle.getAppropriateMultiplier(isBlockBeingPlaced, ConfigHandler.maxGenericSplash_onPlace, 0);
            }
        }
        return 2;
    }

    private static int getAppropriateMultiplier(boolean isBlockBeingPlaced, int blockPlaceMultiplier, int blockBreakMultiplier) {
        if (isBlockBeingPlaced) {
            return blockPlaceMultiplier;
        }
        return blockBreakMultiplier;
    }
}

