/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle_spawning;

import games.enchanted.eg_particle_interactions.common.particle_spawning.ParticleCategory;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SpawnParticlesUtil {
    public static boolean isParticleOutsideRenderDistance(@NotNull ParticleCategory particleCategory, BlockPos particlePos) {
        return SpawnParticlesUtil.isParticleOutsideRenderDistance(particleCategory, particlePos.getX(), particlePos.getY(), particlePos.getZ());
    }

    public static boolean isParticleOutsideRenderDistance(@NotNull ParticleCategory particleCategory, double x, double y, double z) {
        double maxDistance;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        double distanceFromPlayer = MathHelpers.getDistanceBetweenPoints(player.getX() / 16.0, player.getY() / 16.0, player.getZ() / 16.0, x / 16.0, y / 16.0, z / 16.0);
        return distanceFromPlayer >= (maxDistance = (double)Math.min(particleCategory.getMaxDistance(), (Integer)Minecraft.getInstance().options.renderDistance().get()));
    }

    public static void spawnParticleInCircle(ParticleOptions particleOptions, ClientLevel level, Vec3 center, int amount, float spread, float radius, float outwardVelocityMultiplier, float verticalVelocityBase, float verticalVelocityMultiplier) {
        SpawnParticlesUtil.spawnParticleInCircle(() -> particleOptions, level, center, amount, spread, radius, outwardVelocityMultiplier, verticalVelocityBase, verticalVelocityMultiplier);
    }

    public static void spawnParticleInCircle(Supplier<ParticleOptions> particleOptions, ClientLevel level, Vec3 center, int amount, float spread, float radius, float outwardVelocityMultiplier, float verticalVelocityBase, float verticalVelocityMultiplier) {
        float randomAngleOffset = (float)Math.toRadians(MathHelpers.randomBetween(0.0f, 360.0f));
        radius /= 2.0f;
        for (int i = 0; i < amount; ++i) {
            float progressRadians = (float)Math.toRadians((float)i / (float)amount * 360.0f) + randomAngleOffset;
            double distX = (double)radius * Math.cos(progressRadians) + (double)MathHelpers.randomBetween(-(spread / 2.0f), spread / 2.0f);
            double distZ = (double)radius * Math.sin(progressRadians) + (double)MathHelpers.randomBetween(-(spread / 2.0f), spread / 2.0f);
            double x = center.x + distX;
            double z = center.z + distZ;
            double distFromCenter = Math.max(Math.abs(distX), Math.abs(distZ));
            level.addParticle(particleOptions.get(), x, center.y, z, Math.clamp(distX, -1.0, 1.0) * (double)outwardVelocityMultiplier, (double)verticalVelocityBase + Math.abs((double)(radius + spread / 2.0f) - distFromCenter) * (double)verticalVelocityMultiplier, Math.clamp(distZ, -1.0, 1.0) * (double)outwardVelocityMultiplier);
        }
    }

    public static void spawnMostlyUpwardsMotionParticleOption(Level level, ParticleOptions particleOptions, double xPos, double yPos, double zPos, double velocityIntensity) {
        level.addParticle(particleOptions, xPos, yPos, zPos, (level.random.nextDouble() - 0.5) * velocityIntensity * 0.4, Math.abs((level.random.nextDouble() - 0.25) * velocityIntensity) + 0.25, (level.random.nextDouble() - 0.5) * velocityIntensity * 0.4);
    }
}

