/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.platform;

import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.neoforge.registry.NeoParticleProviderRegistry;
import java.nio.file.Path;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class PlatformHelper {
    public static String getPlatformName() {
        return "NeoForge";
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static String getEnvironmentName() {
        return PlatformHelper.isDevelopmentEnvironment() ? "development" : "production";
    }

    public static SimpleParticleType createNewSimpleParticle(boolean alwaysShow) {
        return new SimpleParticleType(alwaysShow);
    }

    public static <T extends ParticleOptions> void registerParticleProvider(ParticleType<T> particleType, ModParticleTypes.SpriteProviderReg<T> particleProvider) {
        NeoParticleProviderRegistry.registerProviderWhenReady(particleType, particleProvider);
    }

    public static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }
}

