/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.util;

import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeHelpers {
    static ArrayList<Biome> SWAMPY_BIOMES = new ArrayList();

    public static boolean isWarmBiomeOrDimension(Level level, BlockPos blockPos) {
        Biome biome = (Biome)level.getBiome(blockPos).value();
        return !biome.hasPrecipitation() || level.dimensionType().ultraWarm();
    }

    public static boolean isSwampyBiome(Level level, BlockPos blockPos) {
        Biome biome = (Biome)level.getBiome(blockPos).value();
        if (SWAMPY_BIOMES.contains(biome)) {
            return true;
        }
        boolean isSwampyBiome = RegistryHelpers.isBiomeInTag(RegistryHelpers.getLocationFromBiome(biome), RegistryHelpers.getBiomeTagKey(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_swamp")));
        if (isSwampyBiome) {
            SWAMPY_BIOMES.add(biome);
        }
        return isSwampyBiome;
    }
}

