/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.util;

import games.enchanted.eg_particle_interactions.common.ParticleInteractionsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TextureHelpers {
    @NotNull
    public static TextureAtlas getTextureAtlas(ResourceLocation atlasLocation) {
        return Minecraft.getInstance().getModelManager().getAtlas(atlasLocation);
    }

    public static TextureAtlasSprite getSpriteFromBlockAtlas(ResourceLocation location) {
        return TextureHelpers.getTextureAtlas(TextureHelpers.getBlocksAtlasID()).getSprite(location);
    }

    public static TextureAtlasSprite getDebugSprite() {
        return TextureHelpers.getSpriteFromBlockAtlas(ResourceLocation.withDefaultNamespace((String)"block/debug"));
    }

    public static TextureAtlasSprite getParticlePaletteSprite(ResourceLocation location) {
        return ParticleInteractionsMod.particlePaletteAtlas.get(location);
    }

    public static TextureAtlasSprite getParticlePaletteOrBlockSprite(ResourceLocation blockLocation, ResourceLocation fallbackSpriteLocation) {
        TextureAtlasSprite particlePaletteSprite = TextureHelpers.getParticlePaletteSprite(blockLocation);
        if (particlePaletteSprite.contents().name() == MissingTextureAtlasSprite.getLocation()) {
            return TextureHelpers.getTextureAtlas(TextureHelpers.getBlocksAtlasID()).getSprite(fallbackSpriteLocation);
        }
        return particlePaletteSprite;
    }

    public static ResourceLocation getBlocksAtlasID() {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

