/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.neoforge;

import games.enchanted.eg_particle_interactions.common.ParticleInteractionsMod;
import games.enchanted.eg_particle_interactions.common.config.ConfigScreen;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.neoforge.registry.NeoParticleProviderRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="eg_particle_interactions", dist={Dist.CLIENT})
public class NeoForgeEntry {
    public final IEventBus eventBus;

    public NeoForgeEntry(IEventBus bus) {
        this.eventBus = bus;
        ParticleInteractionsMod.startOfModLoading();
        bus.addListener(event -> {
            if (event.getRegistry().key().equals(Registries.PARTICLE_TYPE)) {
                ModParticleTypes.registerParticles();
            }
        });
        bus.addListener(event -> ParticleInteractionsMod.createReloadListeners(Minecraft.getInstance().getTextureManager()).forEach(resourceLocationAndListenerPair -> event.addListener((ResourceLocation)resourceLocationAndListenerPair.key(), (PreparableReloadListener)resourceLocationAndListenerPair.value())));
        bus.addListener(NeoParticleProviderRegistry::registerParticleProviders);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> ConfigScreen.createConfigScreen(parent));
        ParticleInteractionsMod.endOfModLoading();
    }
}

