//? if fabric {
package games.enchanted.eg_particle_interactions.fabric;

import games.enchanted.eg_particle_interactions.common.Constants;
import games.enchanted.eg_particle_interactions.common.ParticleInteractionsMod;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.resource.ClientResourceReload;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class FabricClientEntry implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        ParticleInteractionsMod.startOfModLoading();

        // register particles
        ModParticleTypes.registerParticles();

        // register client resource reload listener
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(
            new SimpleSynchronousResourceReloadListener() {
                @Override
                public class_2960 getFabricId() {
                    return class_2960.method_60655(Constants.MOD_ID, "client_resource_reloader");
                }

                @Override
                public void method_14491(class_3300 resourceManager) {
                    ClientResourceReload.onReload(resourceManager);
                }
            }
        );

        ParticleInteractionsMod.endOfModLoading();
    }
}
//?}
