package games.enchanted.eg_particle_interactions.common.particle.option;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class TintedParticleOption implements class_2394 {
    public static final int BRUSH_COLOUR = 0xcec5d6;
    public static final float BRUSH_VARIATION = 0.23F;
    public static final TintedParticleOption BRUSH_OPTION = new TintedParticleOption(ModParticleTypes.BRUSH_DUST, TintedParticleOption.BRUSH_COLOUR, TintedParticleOption.BRUSH_VARIATION, true);
    public static final TintedParticleOption BRUSH_SPECK_OPTION = new TintedParticleOption(ModParticleTypes.BRUSH_DUST_SPECK, TintedParticleOption.BRUSH_COLOUR, TintedParticleOption.BRUSH_VARIATION, true);

    public static final int ITEM_FRAME_COLOUR = 0xfffcf7;
    public static final float ITEM_FRAME_VARIATION = 0.18F;
    public static final TintedParticleOption ITEM_FRAME_DUST_OPTION = new TintedParticleOption(ModParticleTypes.ITEM_FRAME_DUST, TintedParticleOption.ITEM_FRAME_COLOUR, TintedParticleOption.ITEM_FRAME_VARIATION, true);
    public static final TintedParticleOption ITEM_FRAME_DUST_SPECK_OPTION = new TintedParticleOption(ModParticleTypes.ITEM_FRAME_DUST_SPECK, TintedParticleOption.ITEM_FRAME_COLOUR, TintedParticleOption.ITEM_FRAME_VARIATION, true);

    public static final int GLOW_ITEM_FRAME_COLOUR = 0xffe9cf;
    public static final float GLOW_ITEM_FRAME_VARIATION = 0.18F;
    public static final TintedParticleOption GLOW_ITEM_FRAME_DUST_OPTION = new TintedParticleOption(ModParticleTypes.GLOW_ITEM_FRAME_DUST, TintedParticleOption.GLOW_ITEM_FRAME_COLOUR, TintedParticleOption.GLOW_ITEM_FRAME_VARIATION, true);
    public static final TintedParticleOption GLOW_ITEM_FRAME_DUST_SPECK_OPTION = new TintedParticleOption(ModParticleTypes.GLOW_ITEM_FRAME_DUST_SPECK, TintedParticleOption.GLOW_ITEM_FRAME_COLOUR, TintedParticleOption.GLOW_ITEM_FRAME_VARIATION, true);

    public static final int REDSTONE = 0xf70000;
    public static final int REDSTONE_UNPOWERED = 0x660000;
    public static final TintedParticleOption REDSTONE_DUST_OPTION = new TintedParticleOption(ModParticleTypes.REDSTONE_DUST, TintedParticleOption.REDSTONE, 0.4F, true);
    public static final TintedParticleOption REDSTONE_DUST_UNPOWERED_OPTION = new TintedParticleOption(ModParticleTypes.REDSTONE_DUST, TintedParticleOption.REDSTONE_UNPOWERED, 0.2F, true);

    private final class_2396<TintedParticleOption> type;
    private final int color;
    private final float variationAmount;
    private boolean uniformVariation;

    public TintedParticleOption(class_2396<TintedParticleOption> type, int colour, float variationAmount) {
        this.type = type;
        this.color = colour;
        this.variationAmount = variationAmount;
        this.uniformVariation = false;
    }

    public TintedParticleOption(class_2396<TintedParticleOption> type, int colour, float variationAmount, boolean uniformVariation) {
        this(type, colour, variationAmount);
        this.uniformVariation = uniformVariation;
    }

    private static Codec<TintedParticleOption> createCodec(class_2396<TintedParticleOption> type) {
        return RecordCodecBuilder.create((RecordCodecBuilder.Instance<TintedParticleOption> instance) ->
            instance.group(
                class_5699.field_54067.fieldOf("colour").forGetter(TintedParticleOption::getColor),
                Codec.FLOAT.optionalFieldOf("variation_amount", 0.06f).forGetter(TintedParticleOption::getVariationAmount),
                Codec.BOOL.optionalFieldOf("uniform_variation", false).forGetter(TintedParticleOption::getUniformVariation)
            )
            .apply(
                instance,
                (Integer colour, Float variation, Boolean uniformVariation) -> new TintedParticleOption(type, colour, variation, uniformVariation)
            )
        );
    }

    public static MapCodec<TintedParticleOption> codec(class_2396<TintedParticleOption> type) {
        return createCodec(type).fieldOf("colour_options");
    }

    public static class_9139<? super class_9129, TintedParticleOption> streamCodec(class_2396<TintedParticleOption> type) {
        return class_9135.method_56368(createCodec(type));
    }

    public @NotNull class_2396<TintedParticleOption> method_10295() {
        return this.type;
    }

    public int getColor() {
        return this.color;
    }

    public float getVariationAmount() {
        return this.variationAmount;
    }

    public boolean getUniformVariation() {
        return this.uniformVariation;
    }

    /**
     * Returns a randomised colour based on the parameters of this particle option
     *
     * @return an r, g, b integer array
     */
    public int[] getRandomisedColour() {
        int[] rgb = ColourUtil.RGBint_to_RGB(this.getColor());
        float colourVariation = this.getVariationAmount();

        int[] randomRgb;
        if(this.getUniformVariation()) {
            randomRgb = ColourUtil.randomiseNegativeUniform(rgb, colourVariation);
        } else {
            randomRgb = ColourUtil.randomiseNegative(rgb, colourVariation);
        }
        return randomRgb;
    }
}