package games.enchanted.eg_particle_interactions.common.particle_spawning;


import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2462;
import net.minecraft.class_2680;

public class ParticlePositionHelpers {
    private static final float[][][] repeaterPositions = {
            new float[][]{{0.5f, 9/16f}, {0.5f, 7/16f}, {0.5f, 5/16f}, {0.5f, 3/16f}},
            new float[][]{{7/16f, 0.5f}, {9/16f, 0.5f}, {11/16f, 0.5f}, {13/16f, 0.5f}},
            new float[][]{{0.5f, 7/16f}, {0.5f, 9/16f}, {0.5f, 11/16f}, {0.5f, 13/16f}},
            new float[][]{{9/16f, 0.5f}, {7/16f, 0.5f}, {5/16f, 0.5f}, {3/16f, 0.5f}},
            new float[][]{{0f, 0f}, {0f, 0f}, {0f, 0f}, {0f, 0f}}
    };
    public static float[] getRedstoneRepeaterInteractionPos(class_2680 repeaterState) {
        class_2350 repeaterDirection = repeaterState.method_11654(class_2462.field_11177);
        int repeaterDelay = repeaterState.method_11654(class_2462.field_11451);

        int positionsIndex;
        switch (repeaterDirection) {
            case field_11043 -> positionsIndex = 0;
            case field_11034 ->  positionsIndex = 1;
            case field_11035 -> positionsIndex = 2;
            case field_11039 ->  positionsIndex = 3;
            default ->    positionsIndex = 4;
        }

        final float height = 0.4f;
        if(repeaterDelay - 1 < 4 && repeaterDelay - 1 >= 0) {
            float[] xyPos = repeaterPositions[positionsIndex][repeaterDelay - 1];
            return new float[]{xyPos[0], height, xyPos[1]};
        }

        return new float[]{0f, height, 0f};
    }

    private static final float[][] comparatorPositions = {
        new float[]{0.5f, 13/16f},
        new float[]{3/16f, 0.5f},
        new float[]{0.5f, 3/16f},
        new float[]{13/16f, 0.5f},
        new float[]{0f, 0f}
    };
    public static float[] getRedstoneComparatorInteractionPos(class_2680 comparatorState) {
        class_2350 comparatorDirection = comparatorState.method_11654(class_2286.field_11177);

        int positionsIndex;
        switch (comparatorDirection) {
            case field_11043 -> positionsIndex = 0;
            case field_11034 ->  positionsIndex = 1;
            case field_11035 -> positionsIndex = 2;
            case field_11039 ->  positionsIndex = 3;
            default ->    positionsIndex = 4;
        }

        final float height = 0.4f;
        float[] xyPos = comparatorPositions[positionsIndex];
        return new float[]{xyPos[0], height, xyPos[1]};
    }

    public static double[] getRandomFurnaceParticlePosition(class_2338 blockPos, class_2680 furnaceState) {
        class_2350 direction = furnaceState.method_11654(class_2363.field_11104);
        class_2350.class_2351 direction$axis = direction.method_10166();
        double baseX = blockPos.method_10263() + 0.5;
        double baseY = blockPos.method_10264();
        double baseZ = blockPos.method_10260() + 0.5;

        double outwardOffset = 0.52;
        double randomOffset = MathHelpers.randomBetween(-0.3f, 0.3f);
        double offsetX = direction$axis == class_2350.class_2351.field_11048 ? direction.method_10148() * outwardOffset : randomOffset;
        double offsetY = MathHelpers.randomBetween(0, 0.375f);
        double offsetZ = direction$axis == class_2350.class_2351.field_11051 ? direction.method_10165() * outwardOffset : randomOffset;

        return new double[]{baseX + offsetX, baseY + offsetY, baseZ + offsetZ};
    }
}
