/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config.controller;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.eg_particle_interactions.common.config.controller.BlockLocationController;
import games.enchanted.eg_particle_interactions.common.config.controller.generic.GenericListControllerElement;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockLocationControllerElement
extends GenericListControllerElement<BlockOrTagLocation, BlockLocationController> {
    private static final class_2960 BLOCK_TAG_ICON = class_2960.method_60655((String)"eg_particle_interactions", (String)"block_tag_icon");

    public BlockLocationControllerElement(BlockLocationController control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
    }

    public List<BlockOrTagLocation> computeMatchingValues() {
        if (this.inputField.startsWith("#")) {
            String value = this.inputField.replace("#", "");
            List<class_2960> tagResourceLocations = RegistryHelpers.getMatchingTagLocations(value, class_7923.field_41175).toList();
            ArrayList<BlockOrTagLocation> tagLocations = new ArrayList<BlockOrTagLocation>();
            BlockOrTagLocation validatedLoc = RegistryHelpers.validateBlockOrTagLocationWithFallback(this.inputField, null);
            this.currentItem = validatedLoc;
            if (!validatedLoc.location().method_12832().isEmpty()) {
                this.matchingItems.put(validatedLoc.location(), validatedLoc);
                tagLocations.add(validatedLoc);
            }
            for (class_2960 tagResourceLocation : tagResourceLocations) {
                this.matchingItems.put(tagResourceLocation, validatedLoc);
                tagLocations.add(new BlockOrTagLocation(tagResourceLocation, true));
            }
            return tagLocations;
        }
        List<class_2960> blockResourceLocations = RegistryHelpers.getMatchingLocations(this.inputField, class_7923.field_41175).toList();
        ArrayList<BlockOrTagLocation> blockOrTagLocations = new ArrayList<BlockOrTagLocation>();
        class_2960 validatedLoc = RegistryHelpers.validateBlockLocationWithFallback(this.inputField, null);
        this.currentItem = validatedLoc == null ? null : new BlockOrTagLocation(validatedLoc);
        for (class_2960 blockLocation : blockResourceLocations) {
            class_2248 blockFromLocation = RegistryHelpers.getBlockFromLocation(blockLocation);
            if (blockFromLocation.method_9564().method_26215()) continue;
            this.matchingItems.put(blockLocation, new BlockOrTagLocation(RegistryHelpers.getLocationFromBlock(blockFromLocation)));
            blockOrTagLocations.add(new BlockOrTagLocation(blockLocation));
        }
        return blockOrTagLocations;
    }

    @Override
    public class_1792 getItemToRender(BlockOrTagLocation value) {
        if (value.isTag()) {
            return null;
        }
        return RegistryHelpers.getBlockFromLocation(value.location()).method_8389();
    }

    @Override
    protected void renderDropdownEntry(class_332 graphics, Dimension<Integer> entryDimension, BlockOrTagLocation blockOrTagLocation) {
        super.renderDropdownEntry(graphics, entryDimension, blockOrTagLocation);
        if (blockOrTagLocation.isTag()) {
            this.renderTagIcon(graphics, (Integer)entryDimension.xLimit() - 2, (Integer)entryDimension.y() + 1);
            return;
        }
        this.renderItemIcon(graphics, this.getItemToRender(blockOrTagLocation), (Integer)entryDimension.xLimit() - 2, (Integer)entryDimension.y() + 1);
    }

    @Override
    public class_2561 getRenderedValueText() {
        BlockOrTagLocation currentValue = (BlockOrTagLocation)((BlockLocationController)((Object)this.getController())).option().pendingValue();
        if (currentValue.isTag()) {
            return TextUtil.formatResourceLocationToChatComponent(currentValue.location(), "#");
        }
        return class_2561.method_43471((String)RegistryHelpers.getBlockFromLocation(currentValue.location()).method_63499());
    }

    @Override
    @Nullable
    public class_2561 getHoverTooltipText() {
        BlockOrTagLocation value = (BlockOrTagLocation)((BlockLocationController)((Object)this.getController())).option().pendingValue();
        return TextUtil.formatResourceLocationToChatComponent(value.location(), value.isTag() ? "#" : "");
    }

    @Override
    protected void renderItemIcon(class_332 graphics, class_1792 item, int x, int y) {
        if (((BlockOrTagLocation)((BlockLocationController)((Object)this.getController())).option().pendingValue()).isTag()) {
            this.renderTagIcon(graphics, x, y);
            return;
        }
        super.renderItemIcon(graphics, item, x, y);
    }

    protected void renderTagIcon(class_332 graphics, int x, int y) {
        graphics.method_52706(class_10799.field_56883, BLOCK_TAG_ICON, x, y, 16, 16);
    }
}

